/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorCacheNearConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private boolean nearEnabled;
    private int nearStartSize;
    private String nearEvictPlc;
    private Integer nearEvictMaxSize;

    public static VisorCacheNearConfiguration from(CacheConfiguration ccfg) {
        VisorCacheNearConfiguration cfg = new VisorCacheNearConfiguration();
        cfg.nearEnabled = GridCacheUtils.isNearEnabled(ccfg);
        if (cfg.nearEnabled) {
            NearCacheConfiguration nccfg = ccfg.getNearConfiguration();
            cfg.nearStartSize = nccfg.getNearStartSize();
            cfg.nearEvictPlc = VisorTaskUtils.compactClass(nccfg.getNearEvictionPolicy());
            cfg.nearEvictMaxSize = VisorTaskUtils.evictionPolicyMaxSize(nccfg.getNearEvictionPolicy());
        }
        return cfg;
    }

    public boolean nearEnabled() {
        return this.nearEnabled;
    }

    public int nearStartSize() {
        return this.nearStartSize;
    }

    @Nullable
    public String nearEvictPolicy() {
        return this.nearEvictPlc;
    }

    @Nullable
    public Integer nearEvictMaxSize() {
        return this.nearEvictMaxSize;
    }

    public String toString() {
        return S.toString(VisorCacheNearConfiguration.class, this);
    }
}

