/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheSwapManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCachePartitions;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCachePartitionsTask
extends VisorMultiNodeTask<String, Map<UUID, VisorCachePartitions>, VisorCachePartitions> {
    private static final long serialVersionUID = 0L;

    protected VisorCachePartitionsJob job(String arg) {
        return new VisorCachePartitionsJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, VisorCachePartitions> reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, VisorCachePartitions> parts = new HashMap<UUID, VisorCachePartitions>();
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                throw res.getException();
            }
            parts.put(res.getNode().id(), (VisorCachePartitions)res.getData());
        }
        return parts;
    }

    private static class VisorCachePartitionsJob
    extends VisorJob<String, VisorCachePartitions> {
        private static final long serialVersionUID = 0L;

        private VisorCachePartitionsJob(String cacheName, boolean debug) {
            super(cacheName, debug);
        }

        @Override
        protected VisorCachePartitions run(String cacheName) throws IgniteException {
            boolean partitioned;
            if (this.debug) {
                VisorTaskUtils.log(this.ignite.log(), "Collecting partitions for cache: " + VisorTaskUtils.escapeName(cacheName));
            }
            VisorCachePartitions parts = new VisorCachePartitions();
            GridCacheAdapter ca = this.ignite.context().cache().internalCache(cacheName);
            if (ca == null || !ca.context().started()) {
                return parts;
            }
            CacheConfiguration cfg = ca.configuration();
            CacheMode mode = cfg.getCacheMode();
            boolean bl = partitioned = (mode == CacheMode.PARTITIONED || mode == CacheMode.REPLICATED) && ca.context().affinityNode();
            if (partitioned) {
                GridCacheSwapManager swap = ca.context().swap();
                GridDhtCacheAdapter dca = null;
                if (ca instanceof GridNearCacheAdapter) {
                    dca = ((GridNearCacheAdapter)ca).dht();
                } else if (ca instanceof GridDhtCacheAdapter) {
                    dca = (GridDhtCacheAdapter)ca;
                }
                if (dca != null) {
                    GridDhtPartitionTopology top = dca.topology();
                    List<GridDhtLocalPartition> locParts = top.localPartitions();
                    try {
                        for (GridDhtLocalPartition part : locParts) {
                            int p = part.id();
                            int sz = part.publicSize();
                            if (part.primary(AffinityTopologyVersion.NONE)) {
                                parts.addPrimary(p, sz, swap.offheapEntriesCount(p), swap.swapEntriesCount(p));
                                continue;
                            }
                            if (part.state() != GridDhtPartitionState.OWNING || !part.backup(AffinityTopologyVersion.NONE)) continue;
                            parts.addBackup(p, sz, swap.offheapEntriesCount(p), swap.swapEntriesCount(p));
                        }
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException("Failed to collect keys distribution in partitions", e);
                    }
                }
            }
            return parts;
        }

        public String toString() {
            return S.toString(VisorCachePartitionsJob.class, this);
        }
    }
}

