/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.U;

public class VisorCacheQueryConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String[] sqlFuncClss;
    private long longQryWarnTimeout;
    private boolean sqlEscapeAll;
    private String[] indexedTypes;
    private int sqlOnheapRowCacheSize;

    private static String[] compactClasses(Class<?>[] clss) {
        if (clss == null) {
            return null;
        }
        int len = clss.length;
        String[] res = new String[len];
        for (int i = 0; i < len; ++i) {
            res[i] = U.compact(clss[i].getName());
        }
        return res;
    }

    public VisorCacheQueryConfiguration from(CacheConfiguration ccfg) {
        this.sqlFuncClss = VisorCacheQueryConfiguration.compactClasses(ccfg.getSqlFunctionClasses());
        this.longQryWarnTimeout = ccfg.getLongQueryWarningTimeout();
        this.sqlEscapeAll = ccfg.isSqlEscapeAll();
        this.indexedTypes = VisorCacheQueryConfiguration.compactClasses(ccfg.getIndexedTypes());
        this.sqlOnheapRowCacheSize = ccfg.getSqlOnheapRowCacheSize();
        return this;
    }

    public String[] sqlFunctionClasses() {
        return this.sqlFuncClss;
    }

    public long longQueryWarningTimeout() {
        return this.longQryWarnTimeout;
    }

    public boolean sqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public String[] indexedTypes() {
        return this.indexedTypes;
    }

    public int sqlOnheapRowCacheSize() {
        return this.sqlOnheapRowCacheSize;
    }
}

