/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsKey;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheQueryDetailMetrics;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCacheQueryDetailMetricsCollectorTask
extends VisorMultiNodeTask<Long, Collection<VisorCacheQueryDetailMetrics>, Collection<? extends QueryDetailMetrics>> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheQueryDetailMetricsCollectorJob job(Long arg) {
        return new VisorCacheQueryDetailMetricsCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Collection<VisorCacheQueryDetailMetrics> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap taskRes = new HashMap();
        for (ComputeJobResult computeJobResult : results) {
            if (computeJobResult.getException() != null) {
                throw computeJobResult.getException();
            }
            Collection metrics = (Collection)computeJobResult.getData();
            VisorCacheQueryDetailMetricsCollectorJob.aggregateMetrics(-1L, taskRes, metrics);
        }
        Collection aggMetrics = taskRes.values();
        ArrayList<VisorCacheQueryDetailMetrics> arrayList = new ArrayList<VisorCacheQueryDetailMetrics>(aggMetrics.size());
        for (GridCacheQueryDetailMetricsAdapter m : aggMetrics) {
            arrayList.add(new VisorCacheQueryDetailMetrics().from(m));
        }
        return arrayList;
    }

    private static class VisorCacheQueryDetailMetricsCollectorJob
    extends VisorJob<Long, Collection<? extends QueryDetailMetrics>> {
        private static final long serialVersionUID = 0L;

        protected VisorCacheQueryDetailMetricsCollectorJob(@Nullable Long arg, boolean debug) {
            super(arg, debug);
        }

        private static void aggregateMetrics(long since, Map<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> res, Collection<GridCacheQueryDetailMetricsAdapter> metrics) {
            for (GridCacheQueryDetailMetricsAdapter m : metrics) {
                GridCacheQueryDetailMetricsKey key;
                if (m.lastStartTime() <= since) continue;
                GridCacheQueryDetailMetricsAdapter aggMetrics = res.get(key = m.key());
                res.put(key, aggMetrics == null ? m : aggMetrics.aggregate(m));
            }
        }

        @Override
        protected Collection<? extends QueryDetailMetrics> run(@Nullable Long arg) throws IgniteException {
            assert (arg != null);
            IgniteConfiguration cfg = this.ignite.configuration();
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            Collection<String> cacheNames = cacheProc.cacheNames();
            HashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> aggMetrics = new HashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter>();
            for (String cacheName : cacheNames) {
                IgniteInternalCache cache;
                if (GridCacheUtils.isSystemCache(cacheName) || GridCacheUtils.isIgfsCache(cfg, cacheName) || (cache = cacheProc.cache(cacheName)) == null || !cache.context().started()) continue;
                VisorCacheQueryDetailMetricsCollectorJob.aggregateMetrics(arg, aggMetrics, cache.context().queries().detailMetrics());
            }
            return new ArrayList(aggMetrics.values());
        }

        public String toString() {
            return S.toString(VisorCacheQueryDetailMetricsCollectorJob.class, this);
        }
    }
}

