/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.jdbc.CacheAbstractJdbcStore;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorCacheStoreConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private boolean jdbcStore;
    private String store;
    private String storeFactory;
    private boolean readThrough;
    private boolean writeThrough;
    private boolean writeBehindEnabled;
    private int batchSz;
    private long flushFreq;
    private int flushSz;
    private int flushThreadCnt;

    public VisorCacheStoreConfiguration from(IgniteEx ignite, CacheConfiguration ccfg) {
        IgniteCacheProxy c = ignite.context().cache().jcache(ccfg.getName());
        CacheStore<?, ?> cstore = c != null && c.context().started() ? c.context().store().configuredStore() : null;
        this.jdbcStore = cstore instanceof CacheAbstractJdbcStore;
        this.store = VisorTaskUtils.compactClass(cstore);
        this.storeFactory = VisorTaskUtils.compactClass(ccfg.getCacheStoreFactory());
        this.readThrough = ccfg.isReadThrough();
        this.writeThrough = ccfg.isWriteThrough();
        this.writeBehindEnabled = ccfg.isWriteBehindEnabled();
        this.batchSz = ccfg.getWriteBehindBatchSize();
        this.flushFreq = ccfg.getWriteBehindFlushFrequency();
        this.flushSz = ccfg.getWriteBehindFlushSize();
        this.flushThreadCnt = ccfg.getWriteBehindFlushThreadCount();
        return this;
    }

    public boolean enabled() {
        return this.store != null;
    }

    public boolean jdbcStore() {
        return this.jdbcStore;
    }

    @Nullable
    public String store() {
        return this.store;
    }

    public String storeFactory() {
        return this.storeFactory;
    }

    public boolean readThrough() {
        return this.readThrough;
    }

    public boolean writeThrough() {
        return this.writeThrough;
    }

    public boolean writeBehindEnabled() {
        return this.writeBehindEnabled;
    }

    public int batchSize() {
        return this.batchSz;
    }

    public long flushFrequency() {
        return this.flushFreq;
    }

    public int flushSize() {
        return this.flushSz;
    }

    public int flushThreadCount() {
        return this.flushThreadCnt;
    }

    public String toString() {
        return S.toString(VisorCacheStoreConfiguration.class, this);
    }
}

