/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;

@GridInternal
public class VisorCacheSwapBackupsTask
extends VisorOneNodeTask<Set<String>, Map<String, IgniteBiTuple<Integer, Integer>>> {
    private static final long serialVersionUID = 0L;

    protected VisorCachesSwapBackupsJob job(Set<String> names) {
        return new VisorCachesSwapBackupsJob(names, this.debug);
    }

    private static class VisorCachesSwapBackupsJob
    extends VisorJob<Set<String>, Map<String, IgniteBiTuple<Integer, Integer>>> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected IgniteEx g;

        private VisorCachesSwapBackupsJob(Set<String> names, boolean debug) {
            super(names, debug);
        }

        @Override
        protected Map<String, IgniteBiTuple<Integer, Integer>> run(Set<String> names) {
            HashMap<String, IgniteBiTuple<Integer, Integer>> total = new HashMap<String, IgniteBiTuple<Integer, Integer>>();
            ClusterNode locNode = this.g.localNode();
            for (IgniteInternalCache<?, ?> c : this.ignite.cachesx(new IgnitePredicate[0])) {
                int before;
                String cacheName = c.name();
                Affinity<?> aff = this.g.affinity(c.name());
                if (!names.contains(cacheName)) continue;
                Set<Cache.Entry<?, ?>> entries = c.entrySet();
                int after = before = entries.size();
                for (Cache.Entry<?, ?> entry : entries) {
                    if (!aff.isBackup(locNode, entry.getKey()) || !c.evict(entry.getKey())) continue;
                    --after;
                }
                total.put(cacheName, new IgniteBiTuple<Integer, Integer>(before, after));
            }
            return total;
        }

        public String toString() {
            return S.toString(VisorCachesSwapBackupsJob.class, this);
        }
    }
}

