/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.cache.configuration.Factory;
import org.apache.ignite.cache.CacheTypeFieldMetadata;
import org.apache.ignite.cache.CacheTypeMetadata;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.store.jdbc.CacheJdbcPojoStoreFactory;
import org.apache.ignite.cache.store.jdbc.JdbcType;
import org.apache.ignite.cache.store.jdbc.JdbcTypeField;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.VisorCacheTypeFieldMetadata;
import org.apache.ignite.lang.IgniteBiTuple;

public class VisorCacheTypeMetadata
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String dbSchema;
    private String dbTbl;
    private String keyType;
    private String valType;
    @GridToStringInclude
    private Collection<VisorCacheTypeFieldMetadata> keyFields;
    @GridToStringInclude
    private Collection<VisorCacheTypeFieldMetadata> valFields;
    @GridToStringInclude
    private Map<String, String> qryFlds;
    @GridToStringInclude
    private Map<String, String> ascFlds;
    @GridToStringInclude
    private Map<String, String> descFlds;
    @GridToStringInclude
    private Collection<String> txtFlds;
    @GridToStringInclude
    private Map<String, LinkedHashMap<String, IgniteBiTuple<String, Boolean>>> grps;

    public static Collection<VisorCacheTypeMetadata> list(Collection<QueryEntity> qryEntities, Factory factory, Collection<CacheTypeMetadata> types) {
        CacheJdbcPojoStoreFactory jdbcFactory;
        JdbcType[] jdbcTypes;
        ArrayList<VisorCacheTypeMetadata> metas = new ArrayList<VisorCacheTypeMetadata>();
        HashMap<String, VisorCacheTypeMetadata> metaMap = U.newHashMap(qryEntities != null ? qryEntities.size() : 0);
        if (qryEntities != null) {
            for (QueryEntity qryEntity : qryEntities) {
                VisorCacheTypeMetadata meta = VisorCacheTypeMetadata.from(qryEntity);
                metas.add(meta);
                metaMap.put(meta.keyType, meta);
            }
        }
        if (factory != null && factory instanceof CacheJdbcPojoStoreFactory && (jdbcTypes = (jdbcFactory = (CacheJdbcPojoStoreFactory)factory).getTypes()) != null && jdbcTypes.length > 0) {
            for (JdbcType jdbcType : jdbcTypes) {
                JdbcTypeField[] valFields;
                boolean notFound;
                VisorCacheTypeMetadata meta = (VisorCacheTypeMetadata)metaMap.get(jdbcType.getKeyType());
                boolean bl = notFound = meta == null;
                if (notFound) {
                    meta = new VisorCacheTypeMetadata();
                    meta.keyType = jdbcType.getKeyType();
                    meta.valType = jdbcType.getValueType();
                    meta.qryFlds = Collections.emptyMap();
                    meta.ascFlds = Collections.emptyMap();
                    meta.descFlds = Collections.emptyMap();
                    meta.txtFlds = Collections.emptyList();
                    meta.grps = Collections.emptyMap();
                }
                meta.dbSchema = jdbcType.getDatabaseSchema();
                meta.dbTbl = jdbcType.getDatabaseTable();
                JdbcTypeField[] keyFields = jdbcType.getKeyFields();
                if (keyFields != null) {
                    meta.keyFields = new ArrayList<VisorCacheTypeFieldMetadata>(keyFields.length);
                    for (JdbcTypeField fld : keyFields) {
                        meta.keyFields.add(new VisorCacheTypeFieldMetadata(fld.getDatabaseFieldName(), fld.getDatabaseFieldType(), fld.getDatabaseFieldName(), U.compact(fld.getJavaFieldType().getName())));
                    }
                }
                if ((valFields = jdbcType.getValueFields()) != null) {
                    meta.valFields = new ArrayList<VisorCacheTypeFieldMetadata>(valFields.length);
                    for (JdbcTypeField fld : valFields) {
                        meta.valFields.add(new VisorCacheTypeFieldMetadata(fld.getDatabaseFieldName(), fld.getDatabaseFieldType(), fld.getDatabaseFieldName(), U.compact(fld.getJavaFieldType().getName())));
                    }
                }
                if (!notFound) continue;
                metas.add(meta);
            }
        }
        if (types != null) {
            for (CacheTypeMetadata type : types) {
                metas.add(VisorCacheTypeMetadata.from(type));
            }
        }
        return metas;
    }

    public static VisorCacheTypeMetadata from(QueryEntity q) {
        assert (q != null);
        VisorCacheTypeMetadata metadata = new VisorCacheTypeMetadata();
        metadata.keyType = q.getKeyType();
        metadata.valType = q.getValueType();
        metadata.dbSchema = "";
        metadata.dbTbl = "";
        metadata.keyFields = Collections.emptyList();
        metadata.valFields = Collections.emptyList();
        LinkedHashMap<String, String> qryFields = q.getFields();
        metadata.qryFlds = new LinkedHashMap<String, String>(qryFields);
        metadata.ascFlds = Collections.emptyMap();
        metadata.descFlds = Collections.emptyMap();
        metadata.txtFlds = Collections.emptyList();
        Collection<QueryIndex> qryIdxs = q.getIndexes();
        metadata.grps = new LinkedHashMap<String, LinkedHashMap<String, IgniteBiTuple<String, Boolean>>>(qryIdxs.size());
        for (QueryIndex qryIdx : qryIdxs) {
            LinkedHashMap<String, Boolean> qryIdxFlds = qryIdx.getFields();
            LinkedHashMap<String, IgniteBiTuple<String, Boolean>> grpFlds = new LinkedHashMap<String, IgniteBiTuple<String, Boolean>>();
            for (Map.Entry<String, Boolean> qryIdxFld : qryIdxFlds.entrySet()) {
                String fldName = qryIdxFld.getKey();
                grpFlds.put(fldName, new IgniteBiTuple<String, Boolean>(qryFields.get(fldName), qryIdxFld.getValue() == false));
            }
            metadata.grps.put(qryIdx.getName(), grpFlds);
        }
        return metadata;
    }

    public static VisorCacheTypeMetadata from(CacheTypeMetadata m) {
        assert (m != null);
        VisorCacheTypeMetadata metadata = new VisorCacheTypeMetadata();
        metadata.dbSchema = m.getDatabaseSchema();
        metadata.dbTbl = m.getDatabaseTable();
        metadata.keyType = m.getKeyType();
        metadata.valType = m.getValueType();
        ArrayList<VisorCacheTypeFieldMetadata> fields = new ArrayList<VisorCacheTypeFieldMetadata>(m.getKeyFields().size());
        for (CacheTypeFieldMetadata field : m.getKeyFields()) {
            fields.add(VisorCacheTypeFieldMetadata.from(field));
        }
        metadata.keyFields = fields;
        fields = new ArrayList(m.getValueFields().size());
        for (CacheTypeFieldMetadata field : m.getValueFields()) {
            fields.add(VisorCacheTypeFieldMetadata.from(field));
        }
        metadata.valFields = fields;
        metadata.qryFlds = VisorCacheTypeMetadata.convertFieldsMap(m.getQueryFields());
        metadata.ascFlds = VisorCacheTypeMetadata.convertFieldsMap(m.getAscendingFields());
        metadata.descFlds = VisorCacheTypeMetadata.convertFieldsMap(m.getDescendingFields());
        metadata.txtFlds = m.getTextFields();
        metadata.grps = VisorCacheTypeMetadata.convertGrpsMap(m.getGroups());
        return metadata;
    }

    private static Map<String, String> convertFieldsMap(Map<String, Class<?>> base) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(base.size());
        for (Map.Entry<String, Class<?>> e : base.entrySet()) {
            res.put(e.getKey(), U.compact(e.getValue().getName()));
        }
        return res;
    }

    private static Map<String, LinkedHashMap<String, IgniteBiTuple<String, Boolean>>> convertGrpsMap(Map<String, LinkedHashMap<String, IgniteBiTuple<Class<?>, Boolean>>> base) {
        LinkedHashMap<String, LinkedHashMap<String, IgniteBiTuple<String, Boolean>>> res = new LinkedHashMap<String, LinkedHashMap<String, IgniteBiTuple<String, Boolean>>>(base.size());
        for (Map.Entry<String, LinkedHashMap<String, IgniteBiTuple<Class<?>, Boolean>>> e : base.entrySet()) {
            LinkedHashMap<String, IgniteBiTuple<Class<?>, Boolean>> intBase = e.getValue();
            LinkedHashMap<String, IgniteBiTuple<String, Boolean>> intRes = new LinkedHashMap<String, IgniteBiTuple<String, Boolean>>(intBase.size());
            for (Map.Entry<String, IgniteBiTuple<Class<?>, Boolean>> intE : intBase.entrySet()) {
                IgniteBiTuple<Class<?>, Boolean> val = intE.getValue();
                intRes.put(intE.getKey(), new IgniteBiTuple<String, Boolean>(U.compact(val.get1().getName()), val.get2()));
            }
            res.put(e.getKey(), intRes);
        }
        return res;
    }

    public String dbSchema() {
        return this.dbSchema;
    }

    public String dbTbl() {
        return this.dbTbl;
    }

    public String keyType() {
        return this.keyType;
    }

    public String valType() {
        return this.valType;
    }

    public Collection<VisorCacheTypeFieldMetadata> keyFields() {
        return this.keyFields;
    }

    public Collection<VisorCacheTypeFieldMetadata> valFields() {
        return this.valFields;
    }

    public Map<String, String> qryFlds() {
        return this.qryFlds;
    }

    public Map<String, String> ascFlds() {
        return this.ascFlds;
    }

    public Map<String, String> descFlds() {
        return this.descFlds;
    }

    public Collection<String> txtFlds() {
        return this.txtFlds;
    }

    public Map<String, LinkedHashMap<String, IgniteBiTuple<String, Boolean>>> grps() {
        return this.grps;
    }

    public String toString() {
        return S.toString(VisorCacheTypeMetadata.class, this);
    }
}

