/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheSwapManager;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.VisorCache;
import org.apache.ignite.internal.visor.cache.VisorCacheV2;

public class VisorCacheV4
extends VisorCacheV2 {
    private static final long serialVersionUID = 0L;
    private int offHeapPrimaryEntriesCnt;
    private int offHeapBackupEntriesCnt;
    private int swapPrimaryEntriesCnt;
    private int swapBackupEntriesCnt;

    @Override
    public VisorCache from(IgniteEx ignite, String cacheName, int sample) throws IgniteCheckedException {
        VisorCache c = super.from(ignite, cacheName, sample);
        if (c != null && c instanceof VisorCacheV4) {
            VisorCacheV4 cacheV4 = (VisorCacheV4)c;
            GridCacheAdapter ca = ignite.context().cache().internalCache(cacheName);
            if (ca != null && ca.context().started()) {
                GridCacheSwapManager swap = ca.context().swap();
                cacheV4.offHeapPrimaryEntriesCnt = swap.offheapEntriesCount(true, false, AffinityTopologyVersion.NONE);
                cacheV4.offHeapBackupEntriesCnt = swap.offheapEntriesCount(false, true, AffinityTopologyVersion.NONE);
                cacheV4.swapPrimaryEntriesCnt = swap.swapEntriesCount(true, false, AffinityTopologyVersion.NONE);
                cacheV4.swapBackupEntriesCnt = swap.swapEntriesCount(false, true, AffinityTopologyVersion.NONE);
            }
        }
        return c;
    }

    @Override
    protected VisorCache initHistory(VisorCache c) {
        super.initHistory(c);
        if (c instanceof VisorCacheV4) {
            VisorCacheV4 cacheV4 = (VisorCacheV4)c;
            cacheV4.offHeapPrimaryEntriesCnt = this.offHeapPrimaryEntriesCnt;
            cacheV4.offHeapBackupEntriesCnt = this.offHeapBackupEntriesCnt;
            cacheV4.swapPrimaryEntriesCnt = this.swapPrimaryEntriesCnt;
            cacheV4.swapBackupEntriesCnt = this.swapBackupEntriesCnt;
        }
        return c;
    }

    @Override
    public VisorCache history() {
        return this.initHistory(new VisorCacheV4());
    }

    public int offHeapPrimaryEntriesCount() {
        return this.offHeapPrimaryEntriesCnt;
    }

    public int offHeapBackupEntriesCount() {
        return this.offHeapBackupEntriesCnt;
    }

    public int swapPrimaryEntriesCount() {
        return this.swapPrimaryEntriesCnt;
    }

    public int swapBackupEntriesCount() {
        return this.swapBackupEntriesCnt;
    }

    @Override
    public String toString() {
        return S.toString(VisorCacheV4.class, this);
    }
}

