/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorComputeCancelSessionsTask
extends VisorMultiNodeTask<Map<UUID, Set<IgniteUuid>>, Void, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorComputeCancelSessionsJob job(Map<UUID, Set<IgniteUuid>> arg) {
        return new VisorComputeCancelSessionsJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Void reduce0(List<ComputeJobResult> results) {
        return null;
    }

    private static class VisorComputeCancelSessionsJob
    extends VisorJob<Map<UUID, Set<IgniteUuid>>, Void> {
        private static final long serialVersionUID = 0L;

        private VisorComputeCancelSessionsJob(Map<UUID, Set<IgniteUuid>> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(Map<UUID, Set<IgniteUuid>> arg) {
            Set<IgniteUuid> sesIds = arg.get(this.ignite.localNode().id());
            if (sesIds != null && !sesIds.isEmpty()) {
                IgniteCompute compute = this.ignite.compute(this.ignite.cluster().forLocal());
                Map futs = compute.activeTaskFutures();
                for (IgniteUuid sesId : sesIds) {
                    ComputeTaskFuture fut = futs.get(sesId);
                    if (fut == null) continue;
                    fut.cancel();
                }
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorComputeCancelSessionsJob.class, this);
        }
    }
}

