/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.compute.VisorComputeMonitoringHolder;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorComputeToggleMonitoringTask
extends VisorMultiNodeTask<IgniteBiTuple<String, Boolean>, Boolean, Boolean> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected Boolean reduce0(List<ComputeJobResult> results) {
        HashSet toggles = new HashSet();
        for (ComputeJobResult res : results) {
            toggles.add(res.getData());
        }
        return toggles.size() == 1;
    }

    protected VisorComputeToggleMonitoringJob job(IgniteBiTuple<String, Boolean> arg) {
        return new VisorComputeToggleMonitoringJob(arg, this.debug);
    }

    private static class VisorComputeToggleMonitoringJob
    extends VisorJob<IgniteBiTuple<String, Boolean>, Boolean> {
        private static final long serialVersionUID = 0L;

        private VisorComputeToggleMonitoringJob(IgniteBiTuple<String, Boolean> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Boolean run(IgniteBiTuple<String, Boolean> arg) {
            if (VisorTaskUtils.checkExplicitTaskMonitoring(this.ignite)) {
                return true;
            }
            ConcurrentMap<String, VisorComputeMonitoringHolder> storage = this.ignite.cluster().nodeLocalMap();
            VisorComputeMonitoringHolder holder = (VisorComputeMonitoringHolder)storage.get("VISOR_COMPUTE_MONITORING_KEY");
            if (holder == null) {
                VisorComputeMonitoringHolder holderNew = new VisorComputeMonitoringHolder();
                VisorComputeMonitoringHolder holderOld = storage.putIfAbsent("VISOR_COMPUTE_MONITORING_KEY", holderNew);
                holder = holderOld == null ? holderNew : holderOld;
            }
            String visorKey = arg.get1();
            boolean state = arg.get2();
            if (state) {
                holder.startCollect(this.ignite, visorKey);
            } else {
                holder.stopCollect(this.ignite, visorKey);
            }
            return this.ignite.allEventsUserRecordable(VisorTaskUtils.VISOR_TASK_EVTS);
        }

        public String toString() {
            return S.toString(VisorComputeToggleMonitoringJob.class, this);
        }
    }
}

