/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorGatewayTask
implements ComputeTask<Object[], Object> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    protected transient IgniteEx ignite;

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object[] args) throws IgniteException {
        assert (args != null);
        assert (args.length >= 2);
        return Collections.singletonMap(new VisorGatewayJob(args), this.ignite.localNode());
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.WAIT;
    }

    @Override
    @Nullable
    public Object reduce(List<ComputeJobResult> results) throws IgniteException {
        assert (results.size() == 1);
        ComputeJobResult res = F.first(results);
        assert (res != null);
        IgniteException ex = res.getException();
        if (ex != null) {
            throw ex;
        }
        return res.getData();
    }

    private static class VisorGatewayJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected transient IgniteEx ignite;
        @JobContextResource
        protected transient ComputeJobContext jobCtx;
        private final int argsCnt;
        private transient IgniteFuture fut;

        VisorGatewayJob(@Nullable Object[] args) {
            super(args);
            assert (args != null);
            this.argsCnt = args.length;
        }

        @Nullable
        private Object toObject(Class cls, int idx) throws ClassNotFoundException {
            String arg = (String)this.argument(idx);
            if (cls == Collection.class || cls == Set.class) {
                Class<?> itemsCls = Class.forName(arg);
                AbstractCollection res = cls == Collection.class ? new ArrayList() : new HashSet();
                String items = (String)this.argument(idx + 1);
                if (items != null) {
                    for (String item : items.split(";")) {
                        res.add(this.toSimpleObject(itemsCls, item));
                    }
                }
                return res;
            }
            if (cls == IgniteBiTuple.class) {
                Class<?> keyCls = Class.forName(arg);
                String valClsName = (String)this.argument(idx + 1);
                assert (valClsName != null);
                Class<?> valCls = Class.forName(valClsName);
                return new IgniteBiTuple<Object, Object>(this.toSimpleObject(keyCls, (String)this.argument(idx + 2)), this.toSimpleObject(valCls, (String)this.argument(idx + 3)));
            }
            if (cls == Map.class) {
                Class<?> keyCls = Class.forName(arg);
                String valClsName = (String)this.argument(idx + 1);
                assert (valClsName != null);
                Class<?> valCls = Class.forName(valClsName);
                HashMap<Object, Object> res = new HashMap<Object, Object>();
                String entries = (String)this.argument(idx + 2);
                if (entries != null) {
                    for (String entry : entries.split(";")) {
                        if (entry.length() <= 0) continue;
                        String[] values = entry.split("=");
                        assert (values.length >= 1);
                        res.put(this.toSimpleObject(keyCls, values[0]), values.length > 1 ? this.toSimpleObject(valCls, values[1]) : null);
                    }
                }
                return res;
            }
            if (cls == GridTuple3.class) {
                String v2ClsName = (String)this.argument(idx + 1);
                String v3ClsName = (String)this.argument(idx + 2);
                assert (v2ClsName != null);
                assert (v3ClsName != null);
                Class<?> v1Cls = Class.forName(arg);
                Class<?> v2Cls = Class.forName(v2ClsName);
                Class<?> v3Cls = Class.forName(v3ClsName);
                return new GridTuple3<Object, Object, Object>(this.toSimpleObject(v1Cls, (String)this.argument(idx + 3)), this.toSimpleObject(v2Cls, (String)this.argument(idx + 4)), this.toSimpleObject(v3Cls, (String)this.argument(idx + 5)));
            }
            return this.toSimpleObject(cls, arg);
        }

        @Nullable
        private Object toSimpleObject(Class cls, String val) {
            if (val == null || val.equals("null")) {
                return null;
            }
            if (String.class == cls) {
                return val;
            }
            if (Boolean.class == cls || Boolean.TYPE == cls) {
                return Boolean.parseBoolean(val);
            }
            if (Integer.class == cls || Integer.TYPE == cls) {
                return Integer.parseInt(val);
            }
            if (Long.class == cls || Long.TYPE == cls) {
                return Long.parseLong(val);
            }
            if (UUID.class == cls) {
                return UUID.fromString(val);
            }
            if (IgniteUuid.class == cls) {
                return IgniteUuid.fromString(val);
            }
            if (Byte.class == cls || Byte.TYPE == cls) {
                return Byte.parseByte(val);
            }
            if (Short.class == cls || Short.TYPE == cls) {
                return Short.parseShort(val);
            }
            if (Float.class == cls || Float.TYPE == cls) {
                return Float.valueOf(Float.parseFloat(val));
            }
            if (Double.class == cls || Double.TYPE == cls) {
                return Double.parseDouble(val);
            }
            if (BigDecimal.class == cls) {
                return new BigDecimal(val);
            }
            if (Collection.class == cls) {
                return Arrays.asList(val.split(";"));
            }
            if (Set.class == cls) {
                return new HashSet<String>(Arrays.asList(val.split(";")));
            }
            if (Object[].class == cls) {
                return val.split(";");
            }
            if (byte[].class == cls) {
                String[] els = val.split(";");
                if (els.length == 0 || els.length == 1 && els[0].length() == 0) {
                    return new byte[0];
                }
                byte[] res = new byte[els.length];
                for (int i = 0; i < els.length; ++i) {
                    res[i] = Byte.valueOf(els[i]);
                }
                return res;
            }
            return val;
        }

        private static boolean isBuildInObject(Class cls) {
            return cls.isPrimitive() || cls.getName().startsWith("java.") || IgniteUuid.class == cls || IgniteBiTuple.class == cls || GridTuple3.class == cls;
        }

        @Override
        public Object execute() throws IgniteException {
            ArrayList<UUID> nids;
            if (this.fut != null) {
                return this.fut.get();
            }
            String nidsArg = (String)this.argument(0);
            String taskName = (String)this.argument(1);
            Object jobArgs = null;
            if (this.argsCnt > 2) {
                String argClsName = (String)this.argument(2);
                assert (argClsName != null);
                try {
                    Class<?> argCls = Class.forName(argClsName);
                    if (argCls == Void.class) {
                        jobArgs = null;
                    } else if (VisorGatewayJob.isBuildInObject(argCls)) {
                        jobArgs = this.toObject(argCls, 3);
                    } else {
                        int beanArgsCnt = this.argsCnt - 3;
                        for (Constructor<?> ctor : argCls.getDeclaredConstructors()) {
                            Class<?>[] types = ctor.getParameterTypes();
                            if (types.length != beanArgsCnt) continue;
                            Object[] initargs = new Object[beanArgsCnt];
                            for (int i = 0; i < beanArgsCnt; ++i) {
                                String val = (String)this.argument(i + 3);
                                initargs[i] = this.toSimpleObject(types[i], val);
                            }
                            jobArgs = ctor.newInstance(initargs);
                            break;
                        }
                        if (jobArgs == null) {
                            throw new IgniteException("Failed to execute task [task name=" + taskName + "]");
                        }
                    }
                }
                catch (Exception e) {
                    throw new IgniteException("Failed to execute task [task name=" + taskName + "]", e);
                }
            }
            if (nidsArg == null || nidsArg.equals("null") || nidsArg.equals("")) {
                Collection<ClusterNode> nodes = this.ignite.cluster().nodes();
                nids = new ArrayList<UUID>(nodes.size());
                for (ClusterNode node : nodes) {
                    nids.add(node.id());
                }
            } else {
                String[] items = nidsArg.split(";");
                nids = new ArrayList(items.length);
                for (String item : items) {
                    try {
                        nids.add(UUID.fromString(item));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            IgniteCompute comp = this.ignite.compute(this.ignite.cluster().forNodeIds(nids)).withAsync();
            comp.execute(taskName, new VisorTaskArgument<Object>(nids, jobArgs, false));
            this.fut = comp.future();
            this.fut.listen(new CI1<IgniteFuture<Object>>(){

                @Override
                public void apply(IgniteFuture<Object> f) {
                    VisorGatewayJob.this.jobCtx.callcc();
                }
            });
            return this.jobCtx.holdcc();
        }
    }
}

