/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.debug;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.debug.VisorThreadInfo;
import org.apache.ignite.lang.IgniteBiTuple;

@GridInternal
public class VisorThreadDumpTask
extends VisorOneNodeTask<Void, IgniteBiTuple<VisorThreadInfo[], long[]>> {
    private static final long serialVersionUID = 0L;

    protected VisorDumpThreadJob job(Void arg) {
        return new VisorDumpThreadJob(arg, this.debug);
    }

    private static class VisorDumpThreadJob
    extends VisorJob<Void, IgniteBiTuple<VisorThreadInfo[], long[]>> {
        private static final long serialVersionUID = 0L;

        private VisorDumpThreadJob(Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IgniteBiTuple<VisorThreadInfo[], long[]> run(Void arg) {
            ThreadMXBean mx = U.getThreadMx();
            ThreadInfo[] info = mx.dumpAllThreads(true, true);
            VisorThreadInfo[] visorInfo = new VisorThreadInfo[info.length];
            for (int i = 0; i < info.length; ++i) {
                visorInfo[i] = VisorThreadInfo.from(info[i]);
            }
            return new IgniteBiTuple<VisorThreadInfo[], long[]>(visorInfo, mx.findDeadlockedThreads());
        }

        public String toString() {
            return S.toString(VisorDumpThreadJob.class, this);
        }
    }
}

