/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.debug;

import java.io.Serializable;
import java.lang.management.ThreadInfo;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.visor.debug.VisorThreadLockInfo;
import org.apache.ignite.internal.visor.debug.VisorThreadMonitorInfo;

public class VisorThreadInfo
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private static final int MAX_FRAMES = 8;
    private final String name;
    private final Long id;
    private final Thread.State state;
    private final VisorThreadLockInfo lock;
    private final String lockName;
    private final Long lockOwnerId;
    private final String lockOwnerName;
    private final Boolean inNative;
    private final Boolean suspended;
    private final Long waitedCnt;
    private final Long waitedTime;
    private final Long blockedCnt;
    private final Long blockedTime;
    private final StackTraceElement[] stackTrace;
    private final VisorThreadLockInfo[] locks;
    private final VisorThreadMonitorInfo[] lockedMonitors;

    public VisorThreadInfo(String name, Long id, Thread.State state, VisorThreadLockInfo lock, String lockName, Long lockOwnerId, String lockOwnerName, Boolean inNative, Boolean suspended, Long waitedCnt, Long waitedTime, Long blockedCnt, Long blockedTime, StackTraceElement[] stackTrace, VisorThreadLockInfo[] locks, VisorThreadMonitorInfo[] lockedMonitors) {
        this.name = name;
        this.id = id;
        this.state = state;
        this.lock = lock;
        this.lockName = lockName;
        this.lockOwnerId = lockOwnerId;
        this.lockOwnerName = lockOwnerName;
        this.inNative = inNative;
        this.suspended = suspended;
        this.waitedCnt = waitedCnt;
        this.waitedTime = waitedTime;
        this.blockedCnt = blockedCnt;
        this.blockedTime = blockedTime;
        this.stackTrace = stackTrace;
        this.locks = locks;
        this.lockedMonitors = lockedMonitors;
    }

    public static VisorThreadInfo from(ThreadInfo ti) {
        VisorThreadMonitorInfo[] minfos;
        VisorThreadLockInfo[] linfos;
        assert (ti != null);
        VisorThreadLockInfo[] visorThreadLockInfoArray = linfos = ti.getLockedSynchronizers() != null ? new VisorThreadLockInfo[ti.getLockedSynchronizers().length] : null;
        if (ti.getLockedSynchronizers() != null) {
            for (int i = 0; i < ti.getLockedSynchronizers().length; ++i) {
                linfos[i] = VisorThreadLockInfo.from(ti.getLockedSynchronizers()[i]);
            }
        }
        VisorThreadMonitorInfo[] visorThreadMonitorInfoArray = minfos = ti.getLockedMonitors() != null ? new VisorThreadMonitorInfo[ti.getLockedMonitors().length] : null;
        if (ti.getLockedMonitors() != null) {
            for (int i = 0; i < ti.getLockedMonitors().length; ++i) {
                minfos[i] = VisorThreadMonitorInfo.from(ti.getLockedMonitors()[i]);
            }
        }
        return new VisorThreadInfo(ti.getThreadName(), ti.getThreadId(), ti.getThreadState(), ti.getLockInfo() != null ? VisorThreadLockInfo.from(ti.getLockInfo()) : null, ti.getLockName(), ti.getLockOwnerId(), ti.getLockOwnerName(), ti.isInNative(), ti.isSuspended(), ti.getWaitedCount(), ti.getWaitedTime(), ti.getBlockedCount(), ti.getBlockedTime(), ti.getStackTrace(), linfos, minfos);
    }

    public String name() {
        return this.name;
    }

    public Long id() {
        return this.id;
    }

    public Thread.State state() {
        return this.state;
    }

    public VisorThreadLockInfo lock() {
        return this.lock;
    }

    public String lockName() {
        return this.lockName;
    }

    public Long lockOwnerId() {
        return this.lockOwnerId;
    }

    public String lockOwnerName() {
        return this.lockOwnerName;
    }

    public Boolean inNative() {
        return this.inNative;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public Long waitedCount() {
        return this.waitedCnt;
    }

    public Long waitedTime() {
        return this.waitedTime;
    }

    public Long blockedCount() {
        return this.blockedCnt;
    }

    public Long blockedTime() {
        return this.blockedTime;
    }

    public StackTraceElement[] stackTrace() {
        return this.stackTrace;
    }

    public VisorThreadLockInfo[] locks() {
        return this.locks;
    }

    public VisorThreadMonitorInfo[] lockedMonitors() {
        return this.lockedMonitors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\"" + this.name + "\"" + " Id=" + this.id + " " + (Object)((Object)this.state));
        if (this.lockName != null) {
            sb.append(" on ").append(this.lockName);
        }
        if (this.lockOwnerName != null) {
            sb.append(" owned by \"").append(this.lockOwnerName).append("\" Id=").append(this.lockOwnerId);
        }
        if (this.suspended.booleanValue()) {
            sb.append(" (suspended)");
        }
        if (this.inNative.booleanValue()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        int maxFrames = Math.min(this.stackTrace.length, 8);
        for (int i = 0; i < maxFrames; ++i) {
            StackTraceElement ste = this.stackTrace[i];
            sb.append("\tat ").append(ste.toString()).append('\n');
            if (i == 0 && this.lock != null) {
                switch (this.state) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(this.lock).append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(this.lock).append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(this.lock).append('\n');
                        break;
                    }
                }
            }
            for (VisorThreadMonitorInfo mi : this.lockedMonitors) {
                if (mi.stackDepth() != i) continue;
                sb.append("\t-  locked ").append(mi).append('\n');
            }
        }
        if (maxFrames < this.stackTrace.length) {
            sb.append("\t...").append('\n');
        }
        if (this.locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(this.locks.length).append('\n');
            for (VisorThreadLockInfo li : this.locks) {
                sb.append("\t- ").append(li).append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

