/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.file;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.file.VisorFileBlock;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteBiTuple;

@GridInternal
public class VisorFileBlockTask
extends VisorOneNodeTask<VisorFileBlockArg, IgniteBiTuple<? extends IOException, VisorFileBlock>> {
    private static final long serialVersionUID = 0L;

    protected VisorFileBlockJob job(VisorFileBlockArg arg) {
        return new VisorFileBlockJob(arg, this.debug);
    }

    private static class VisorFileBlockJob
    extends VisorJob<VisorFileBlockArg, IgniteBiTuple<? extends IOException, VisorFileBlock>> {
        private static final long serialVersionUID = 0L;

        private VisorFileBlockJob(VisorFileBlockArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IgniteBiTuple<? extends IOException, VisorFileBlock> run(VisorFileBlockArg arg) {
            try {
                URL url = U.resolveIgniteUrl(arg.path);
                if (url == null) {
                    return new IgniteBiTuple<NoSuchFileException, Object>(new NoSuchFileException("File path not found: " + arg.path), null);
                }
                VisorFileBlock block = VisorTaskUtils.readBlock(new File(url.toURI()), arg.off, arg.blockSz, arg.lastModified);
                return new IgniteBiTuple<Object, VisorFileBlock>(null, block);
            }
            catch (IOException e) {
                return new IgniteBiTuple<IOException, Object>(e, null);
            }
            catch (URISyntaxException ignored) {
                return new IgniteBiTuple<NoSuchFileException, Object>(new NoSuchFileException("File path not found: " + arg.path), null);
            }
        }

        public String toString() {
            return S.toString(VisorFileBlockJob.class, this);
        }
    }

    public static class VisorFileBlockArg
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String path;
        private final long off;
        private final int blockSz;
        private final long lastModified;

        public VisorFileBlockArg(String path, long off, int blockSz, long lastModified) {
            this.path = path;
            this.off = off;
            this.blockSz = blockSz;
            this.lastModified = lastModified;
        }

        public String toString() {
            return S.toString(VisorFileBlockArg.class, this);
        }
    }
}

