/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.file;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.log.VisorLogFile;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorLatestTextFilesTask
extends VisorOneNodeTask<IgniteBiTuple<String, String>, Collection<VisorLogFile>> {
    private static final long serialVersionUID = 0L;

    protected VisorLatestTextFilesJob job(IgniteBiTuple<String, String> arg) {
        return new VisorLatestTextFilesJob(arg, this.debug);
    }

    private static class VisorLatestTextFilesJob
    extends VisorJob<IgniteBiTuple<String, String>, Collection<VisorLogFile>> {
        private static final long serialVersionUID = 0L;

        private VisorLatestTextFilesJob(IgniteBiTuple<String, String> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        @Nullable
        protected Collection<VisorLogFile> run(IgniteBiTuple<String, String> arg) {
            String path = arg.get1();
            String regexp = arg.get2();
            assert (path != null);
            assert (regexp != null);
            URL url = U.resolveIgniteUrl(path);
            if (url == null) {
                return null;
            }
            try {
                File folder = new File(url.toURI());
                List<VisorLogFile> files = VisorTaskUtils.matchedFiles(folder, regexp);
                if (files.isEmpty()) {
                    return null;
                }
                if (files.size() > 5000) {
                    files = new ArrayList<VisorLogFile>(files.subList(0, 5000));
                }
                return files;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public String toString() {
            return S.toString(VisorLatestTextFilesJob.class, this);
        }
    }
}

