/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.Serializable;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.igfs.VisorIgfsMetrics;

public class VisorIgfs
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private final String name;
    private final IgfsMode mode;
    private final VisorIgfsMetrics metrics;
    private final boolean secondaryFsConfigured;

    public VisorIgfs(String name, IgfsMode mode, VisorIgfsMetrics metrics, boolean secondaryFsConfigured) {
        this.name = name;
        this.mode = mode;
        this.metrics = metrics;
        this.secondaryFsConfigured = secondaryFsConfigured;
    }

    public static VisorIgfs from(IgniteFileSystem igfs) {
        assert (igfs != null);
        return new VisorIgfs(igfs.name(), igfs.configuration().getDefaultMode(), VisorIgfsMetrics.from(igfs), igfs.configuration().getSecondaryFileSystem() != null);
    }

    public String name() {
        return this.name;
    }

    public IgfsMode mode() {
        return this.mode;
    }

    public VisorIgfsMetrics metrics() {
        return this.metrics;
    }

    public boolean secondaryFileSystemConfigured() {
        return this.secondaryFsConfigured;
    }

    public String toString() {
        return S.toString(VisorIgfs.class, this);
    }
}

