/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.Serializable;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class VisorIgfsEndpoint
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private final String igfsName;
    private final String gridName;
    private final String hostName;
    private final int port;

    public VisorIgfsEndpoint(@Nullable String igfsName, String gridName, @Nullable String hostName, int port) {
        this.igfsName = igfsName;
        this.gridName = gridName;
        this.hostName = hostName;
        this.port = port;
    }

    @Nullable
    public String igfsName() {
        return this.igfsName;
    }

    public String gridName() {
        return this.gridName;
    }

    @Nullable
    public String hostName() {
        return this.hostName;
    }

    public int port() {
        return this.port;
    }

    public String authority() {
        String addr = this.hostName + ":" + this.port;
        if (this.igfsName == null && this.gridName == null) {
            return addr;
        }
        if (this.igfsName == null) {
            return this.gridName + "@" + addr;
        }
        if (this.gridName == null) {
            return this.igfsName + "@" + addr;
        }
        return this.igfsName + ":" + this.gridName + "@" + addr;
    }

    public String toString() {
        return S.toString(VisorIgfsEndpoint.class, this);
    }
}

