/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.Serializable;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.igfs.IgfsMetrics;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;

public class VisorIgfsMetrics
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private long totalSpaceSz;
    private long usedSpaceSz;
    private int foldersCnt;
    private int filesCnt;
    private int filesOpenedForRd;
    private int filesOpenedForWrt;
    private long blocksRd;
    private long blocksRdRmt;
    private long blocksWrt;
    private long blocksWrtRmt;
    private long bytesRd;
    private long bytesRdTm;
    private long bytesWrt;
    private long bytesWrtTm;

    public static VisorIgfsMetrics from(IgniteFileSystem igfs) {
        assert (igfs != null);
        IgfsMetrics m = igfs.metrics();
        VisorIgfsMetrics metrics = new VisorIgfsMetrics();
        metrics.totalSpaceSz = igfs.configuration().getMaxSpaceSize();
        metrics.usedSpaceSz = m.localSpaceSize();
        metrics.foldersCnt = m.directoriesCount();
        metrics.filesCnt = m.filesCount();
        metrics.filesOpenedForRd = m.filesOpenedForRead();
        metrics.filesOpenedForWrt = m.filesOpenedForWrite();
        metrics.blocksRd = m.blocksReadTotal();
        metrics.blocksRdRmt = m.blocksReadRemote();
        metrics.blocksWrt = m.blocksWrittenTotal();
        metrics.blocksWrtRmt = m.blocksWrittenRemote();
        metrics.bytesRd = m.bytesRead();
        metrics.bytesRdTm = m.bytesReadTime();
        metrics.bytesWrt = m.bytesWritten();
        metrics.bytesWrtTm = m.bytesWriteTime();
        return metrics;
    }

    public VisorIgfsMetrics add(VisorIgfsMetrics m) {
        assert (m != null);
        this.totalSpaceSz += m.totalSpaceSz;
        this.usedSpaceSz += m.usedSpaceSz;
        this.foldersCnt += m.foldersCnt;
        this.filesCnt += m.filesCnt;
        this.filesOpenedForRd += m.filesOpenedForRd;
        this.filesOpenedForWrt += m.filesOpenedForWrt;
        this.blocksRd += m.blocksRd;
        this.blocksRdRmt += m.blocksRdRmt;
        this.blocksWrt += m.blocksWrt;
        this.blocksWrtRmt += m.blocksWrtRmt;
        this.bytesRd += m.bytesRd;
        this.bytesRdTm += m.bytesRdTm;
        this.bytesWrt += m.bytesWrt;
        this.bytesWrtTm += m.bytesWrtTm;
        return this;
    }

    public VisorIgfsMetrics aggregate(int n) {
        if (n > 0) {
            this.foldersCnt /= n;
            this.filesCnt /= n;
        }
        return this;
    }

    public long totalSpaceSize() {
        return this.totalSpaceSz;
    }

    public long usedSpaceSize() {
        return this.usedSpaceSz;
    }

    public long freeSpaceSize() {
        return this.totalSpaceSz - this.usedSpaceSz;
    }

    public int foldersCount() {
        return this.foldersCnt;
    }

    public int filesCount() {
        return this.filesCnt;
    }

    public int filesOpenedForRead() {
        return this.filesOpenedForRd;
    }

    public int filesOpenedForWrite() {
        return this.filesOpenedForWrt;
    }

    public long blocksRead() {
        return this.blocksRd;
    }

    public long blocksReadRemote() {
        return this.blocksRdRmt;
    }

    public long blocksWritten() {
        return this.blocksWrt;
    }

    public long blocksWrittenRemote() {
        return this.blocksWrtRmt;
    }

    public long bytesRead() {
        return this.bytesRd;
    }

    public long bytesReadTime() {
        return this.bytesRdTm;
    }

    public long bytesWritten() {
        return this.bytesWrt;
    }

    public long bytesWriteTime() {
        return this.bytesWrtTm;
    }

    public String toString() {
        return S.toString(VisorIgfsMetrics.class, this);
    }
}

