/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteBiTuple;

@GridInternal
public class VisorIgfsProfilerClearTask
extends VisorOneNodeTask<String, IgniteBiTuple<Integer, Integer>> {
    private static final long serialVersionUID = 0L;

    protected VisorIgfsProfilerClearJob job(String arg) {
        return new VisorIgfsProfilerClearJob(arg, this.debug);
    }

    private static class VisorIgfsProfilerClearJob
    extends VisorJob<String, IgniteBiTuple<Integer, Integer>> {
        private static final long serialVersionUID = 0L;

        private VisorIgfsProfilerClearJob(String arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IgniteBiTuple<Integer, Integer> run(String arg) {
            int notDeleted;
            int deleted;
            block20: {
                deleted = 0;
                notDeleted = 0;
                try {
                    IgniteFileSystem igfs = this.ignite.fileSystem(arg);
                    Path logsDir = VisorTaskUtils.resolveIgfsProfilerLogsDir(igfs);
                    if (logsDir == null) break block20;
                    PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:igfs-log-" + arg + "-*.csv");
                    try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(logsDir);){
                        for (Path p : dirStream) {
                            if (!matcher.matches(p.getFileName())) continue;
                            try {
                                Files.delete(p);
                                if (Files.exists(p, new LinkOption[0])) {
                                    ++notDeleted;
                                    continue;
                                }
                                ++deleted;
                            }
                            catch (NoSuchFileException noSuchFileException) {
                            }
                            catch (IOException io) {
                                ++notDeleted;
                                this.ignite.log().warning("Profiler log file was not deleted: " + p, io);
                            }
                        }
                    }
                }
                catch (IOException | IllegalArgumentException e) {
                    throw new IgniteException("Failed to clear profiler logs for IGFS: " + arg, e);
                }
                catch (IgniteCheckedException e) {
                    throw U.convertException(e);
                }
            }
            return new IgniteBiTuple<Integer, Integer>(deleted, notDeleted);
        }

        public String toString() {
            return S.toString(VisorIgfsProfilerClearJob.class, this);
        }
    }
}

