/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerUniformityCounters;

public class VisorIgfsProfilerEntry
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    public static final Comparator<VisorIgfsProfilerEntry> ENTRY_TIMESTAMP_COMPARATOR = new Comparator<VisorIgfsProfilerEntry>(){

        @Override
        public int compare(VisorIgfsProfilerEntry a, VisorIgfsProfilerEntry b) {
            return Long.compare(a.ts, b.ts);
        }
    };
    private final String path;
    private final long ts;
    private final IgfsMode mode;
    private final long size;
    private final long bytesRead;
    private final long readTime;
    private final long userReadTime;
    private final long bytesWritten;
    private final long writeTime;
    private final long userWriteTime;
    private double uniformity = -1.0;
    private final VisorIgfsProfilerUniformityCounters counters;
    private final long readSpeed;
    private final long writeSpeed;

    public VisorIgfsProfilerEntry(String path, long ts, IgfsMode mode, long size, long bytesRead, long readTime, long userReadTime, long bytesWritten, long writeTime, long userWriteTime, VisorIgfsProfilerUniformityCounters counters) {
        assert (counters != null);
        this.path = path;
        this.ts = ts;
        this.mode = mode;
        this.size = size;
        this.bytesRead = bytesRead;
        this.readTime = readTime;
        this.userReadTime = userReadTime;
        this.bytesWritten = bytesWritten;
        this.writeTime = writeTime;
        this.userWriteTime = userWriteTime;
        this.counters = counters;
        this.readSpeed = VisorIgfsProfilerEntry.speed(bytesRead, readTime);
        this.writeSpeed = VisorIgfsProfilerEntry.speed(bytesWritten, writeTime);
    }

    private static long speed(long bytes, long time) {
        if (time > 0L) {
            double bytesScaled = (double)bytes * 100000.0;
            double timeScaled = (double)time / 10000.0;
            return (long)(bytesScaled / timeScaled);
        }
        return -1L;
    }

    public String path() {
        return this.path;
    }

    public long timestamp() {
        return this.ts;
    }

    public IgfsMode mode() {
        return this.mode;
    }

    public long size() {
        return this.size;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long readTime() {
        return this.readTime;
    }

    public long userReadTime() {
        return this.userReadTime;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public long writeTime() {
        return this.writeTime;
    }

    public long userWriteTime() {
        return this.userWriteTime;
    }

    public double uniformity() {
        if (this.uniformity < 0.0) {
            this.uniformity = this.counters.calc();
        }
        return this.uniformity;
    }

    public VisorIgfsProfilerUniformityCounters counters() {
        return this.counters;
    }

    public long readSpeed() {
        return this.readSpeed;
    }

    public long writeSpeed() {
        return this.writeSpeed;
    }

    public String toString() {
        return S.toString(VisorIgfsProfilerEntry.class, this);
    }
}

