/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.F;

public class VisorIgfsProfilerUniformityCounters
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private long fileSize;
    private long blockSize = 4096L;
    private final ArrayList<Integer> counters = new ArrayList();

    private long calcBlockSize(long fileSize) {
        return Math.max(4096L, fileSize / 100L);
    }

    public void invalidate(long newFileSize) {
        if (newFileSize < this.fileSize) {
            this.fileSize = newFileSize;
            this.counters.clear();
            this.blockSize = this.calcBlockSize(this.fileSize);
        } else if (newFileSize > this.fileSize) {
            this.compact(newFileSize);
        }
    }

    private void compact(long newFileSize) {
        long newBlockSize = this.calcBlockSize(newFileSize);
        if (this.counters.isEmpty()) {
            this.blockSize = newBlockSize;
        } else if (newBlockSize >= 2L * this.blockSize) {
            int ratio = (int)(newBlockSize / this.blockSize);
            ArrayList<Integer> compacted = new ArrayList<Integer>();
            int sum = 0;
            int cnt = 0;
            for (Integer counter : this.counters) {
                sum += counter.intValue();
                if (++cnt < ratio) continue;
                compacted.add(sum);
                sum = 0;
                cnt = 0;
            }
            if (sum > 0) {
                compacted.add(sum);
            }
            this.counters.clear();
            this.counters.addAll(compacted);
            this.blockSize = newBlockSize;
        }
        this.fileSize = newFileSize;
    }

    private void capacity(int minCap) {
        this.counters.ensureCapacity(minCap);
        while (this.counters.size() < minCap) {
            this.counters.add(0);
        }
    }

    public void increment(long pos, long len) {
        int blockFrom = (int)(pos / this.blockSize);
        int blockTo = (int)((pos + len) / this.blockSize) + 1;
        this.capacity(blockTo);
        for (int i = blockFrom; i < blockTo; ++i) {
            this.counters.set(i, this.counters.get(i) + 1);
        }
    }

    public void aggregate(VisorIgfsProfilerUniformityCounters other) {
        if (this.fileSize < other.fileSize) {
            this.compact(other.fileSize);
        } else if (this.fileSize > other.fileSize) {
            other.compact(this.fileSize);
        }
        int cnt = other.counters.size();
        if (this.counters.size() < cnt) {
            this.capacity(cnt);
        }
        for (int i = 0; i < cnt; ++i) {
            this.counters.set(i, this.counters.get(i) + other.counters.get(i));
        }
    }

    public double calc() {
        if (this.counters.isEmpty()) {
            return -1.0;
        }
        int cap = (int)(this.fileSize / this.blockSize + (long)(this.fileSize % this.blockSize > 0L ? 1 : 0));
        this.capacity(cap);
        int sz = this.counters.size();
        int n = F.sumInt(this.counters);
        double mean = 1.0 / (double)sz;
        double sigma = 0.0;
        for (Integer counter : this.counters) {
            sigma += Math.pow(counter.doubleValue() / (double)n - mean, 2.0);
        }
        sigma = Math.sqrt(sigma / (double)sz);
        return 1.0 - sigma;
    }
}

