/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
public class VisorIgfsResetMetricsTask
extends VisorOneNodeTask<Set<String>, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorIgfsResetMetricsJob job(Set<String> arg) {
        return new VisorIgfsResetMetricsJob(arg, this.debug);
    }

    private static class VisorIgfsResetMetricsJob
    extends VisorJob<Set<String>, Void> {
        private static final long serialVersionUID = 0L;

        private VisorIgfsResetMetricsJob(Set<String> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(Set<String> igfsNames) {
            for (String igfsName : igfsNames) {
                try {
                    this.ignite.fileSystem(igfsName).resetMetrics();
                }
                catch (IllegalArgumentException iae) {
                    throw new IgniteException("Failed to reset metrics for IGFS: " + igfsName, iae);
                }
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorIgfsResetMetricsJob.class, this);
        }
    }
}

