/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorBasicConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String gridName;
    private String ggHome;
    private String locHost;
    private UUID nodeId;
    private String marsh;
    private Object deployMode;
    private Boolean clientMode;
    private boolean daemon;
    private boolean jmxRemote;
    private boolean restart;
    private long netTimeout;
    private String log;
    private long discoStartupDelay;
    private String mBeanSrv;
    private boolean noAscii;
    private boolean noDiscoOrder;
    private boolean noShutdownHook;
    private String progName;
    private boolean quiet;
    private String successFile;
    private boolean updateNtf;

    public static VisorBasicConfiguration from(IgniteEx ignite, IgniteConfiguration c) {
        VisorBasicConfiguration cfg = new VisorBasicConfiguration();
        cfg.gridName = c.getGridName();
        cfg.ggHome = System.getProperty("IGNITE_HOME", c.getIgniteHome());
        cfg.locHost = System.getProperty("IGNITE_LOCAL_HOST", c.getLocalHost());
        cfg.nodeId = ignite.localNode().id();
        cfg.marsh = VisorTaskUtils.compactClass(c.getMarshaller());
        cfg.deployMode = VisorTaskUtils.compactObject((Object)c.getDeploymentMode());
        cfg.clientMode = c.isClientMode();
        cfg.daemon = VisorTaskUtils.boolValue("IGNITE_DAEMON", c.isDaemon());
        cfg.jmxRemote = ignite.isJmxRemoteEnabled();
        cfg.restart = ignite.isRestartEnabled();
        cfg.netTimeout = c.getNetworkTimeout();
        cfg.log = VisorTaskUtils.compactClass(c.getGridLogger());
        cfg.discoStartupDelay = c.getDiscoveryStartupDelay();
        cfg.mBeanSrv = VisorTaskUtils.compactClass(c.getMBeanServer());
        cfg.noAscii = VisorTaskUtils.boolValue("IGNITE_NO_ASCII", false);
        cfg.noDiscoOrder = VisorTaskUtils.boolValue("IGNITE_NO_DISCO_ORDER", false);
        cfg.noShutdownHook = VisorTaskUtils.boolValue("IGNITE_NO_SHUTDOWN_HOOK", false);
        cfg.progName = System.getProperty("IGNITE_PROG_NAME");
        cfg.quiet = VisorTaskUtils.boolValue("IGNITE_QUIET", true);
        cfg.successFile = System.getProperty("IGNITE_SUCCESS_FILE");
        cfg.updateNtf = VisorTaskUtils.boolValue("IGNITE_UPDATE_NOTIFIER", true);
        return cfg;
    }

    @Nullable
    public String gridName() {
        return this.gridName;
    }

    @Nullable
    public String ggHome() {
        return this.ggHome;
    }

    @Nullable
    public String localHost() {
        return this.locHost;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public String marshaller() {
        return this.marsh;
    }

    public Object deploymentMode() {
        return this.deployMode;
    }

    public Boolean clientMode() {
        return this.clientMode;
    }

    public boolean daemon() {
        return this.daemon;
    }

    public boolean jmxRemote() {
        return this.jmxRemote;
    }

    public boolean restart() {
        return this.restart;
    }

    public long networkTimeout() {
        return this.netTimeout;
    }

    public String logger() {
        return this.log;
    }

    public long discoStartupDelay() {
        return this.discoStartupDelay;
    }

    @Nullable
    public String mBeanServer() {
        return this.mBeanSrv;
    }

    public boolean noAscii() {
        return this.noAscii;
    }

    public boolean noDiscoOrder() {
        return this.noDiscoOrder;
    }

    public boolean noShutdownHook() {
        return this.noShutdownHook;
    }

    public String programName() {
        return this.progName;
    }

    public boolean quiet() {
        return this.quiet;
    }

    public String successFile() {
        return this.successFile;
    }

    public boolean updateNotifier() {
        return this.updateNtf;
    }

    public String toString() {
        return S.toString(VisorBasicConfiguration.class, this);
    }
}

