/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;

public class VisorExecutorServiceConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private int pubPoolSize;
    private int sysPoolSz;
    private int mgmtPoolSize;
    private int igfsPoolSize;
    private int p2pPoolSz;
    private int restPoolSz;

    public static VisorExecutorServiceConfiguration from(IgniteConfiguration c) {
        VisorExecutorServiceConfiguration cfg = new VisorExecutorServiceConfiguration();
        cfg.pubPoolSize = c.getPublicThreadPoolSize();
        cfg.sysPoolSz = c.getSystemThreadPoolSize();
        cfg.mgmtPoolSize = c.getManagementThreadPoolSize();
        cfg.p2pPoolSz = c.getPeerClassLoadingThreadPoolSize();
        cfg.igfsPoolSize = c.getIgfsThreadPoolSize();
        ConnectorConfiguration cc = c.getConnectorConfiguration();
        if (cc != null) {
            cfg.restPoolSz = cc.getThreadPoolSize();
        }
        return cfg;
    }

    public int publicThreadPoolSize() {
        return this.pubPoolSize;
    }

    public int systemThreadPoolSize() {
        return this.sysPoolSz;
    }

    public int managementThreadPoolSize() {
        return this.mgmtPoolSize;
    }

    public int igfsThreadPoolSize() {
        return this.igfsPoolSize;
    }

    public int peerClassLoadingThreadPoolSize() {
        return this.p2pPoolSz;
    }

    public int restThreadPoolSize() {
        return this.restPoolSz;
    }

    public String toString() {
        return S.toString(VisorExecutorServiceConfiguration.class, this);
    }
}

