/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.node.VisorAtomicConfiguration;
import org.apache.ignite.internal.visor.node.VisorBasicConfiguration;
import org.apache.ignite.internal.visor.node.VisorExecutorServiceConfiguration;
import org.apache.ignite.internal.visor.node.VisorIgfsConfiguration;
import org.apache.ignite.internal.visor.node.VisorLifecycleConfiguration;
import org.apache.ignite.internal.visor.node.VisorMetricsConfiguration;
import org.apache.ignite.internal.visor.node.VisorPeerToPeerConfiguration;
import org.apache.ignite.internal.visor.node.VisorRestConfiguration;
import org.apache.ignite.internal.visor.node.VisorSegmentationConfiguration;
import org.apache.ignite.internal.visor.node.VisorSpisConfiguration;
import org.apache.ignite.internal.visor.node.VisorTransactionConfiguration;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class VisorGridConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private VisorBasicConfiguration basic;
    private VisorMetricsConfiguration metrics;
    private VisorSpisConfiguration spis;
    private VisorPeerToPeerConfiguration p2p;
    private VisorLifecycleConfiguration lifecycle;
    private VisorExecutorServiceConfiguration execSvc;
    private VisorSegmentationConfiguration seg;
    private String inclProps;
    private int[] inclEvtTypes;
    private VisorRestConfiguration rest;
    private Map<String, ?> userAttrs;
    private Iterable<VisorIgfsConfiguration> igfss;
    private Map<String, String> env;
    private Properties sysProps;
    private VisorAtomicConfiguration atomic;
    private VisorTransactionConfiguration txCfg;

    public VisorGridConfiguration from(IgniteEx ignite) {
        assert (ignite != null);
        IgniteConfiguration c = ignite.configuration();
        this.basic = VisorBasicConfiguration.from(ignite, c);
        this.metrics = VisorMetricsConfiguration.from(c);
        this.spis = VisorSpisConfiguration.from(c);
        this.p2p = VisorPeerToPeerConfiguration.from(c);
        this.lifecycle = VisorLifecycleConfiguration.from(c);
        this.execSvc = VisorExecutorServiceConfiguration.from(c);
        this.seg = VisorSegmentationConfiguration.from(c);
        this.inclProps = VisorTaskUtils.compactArray(c.getIncludeProperties());
        this.inclEvtTypes = c.getIncludeEventTypes();
        this.rest = VisorRestConfiguration.from(c);
        this.userAttrs = c.getUserAttributes();
        this.igfss = VisorIgfsConfiguration.list(c.getFileSystemConfiguration());
        this.env = new HashMap<String, String>(System.getenv());
        this.sysProps = IgniteSystemProperties.snapshot();
        this.atomic = VisorAtomicConfiguration.from(c.getAtomicConfiguration());
        this.txCfg = VisorTransactionConfiguration.from(c.getTransactionConfiguration());
        return this;
    }

    public VisorBasicConfiguration basic() {
        return this.basic;
    }

    public VisorMetricsConfiguration metrics() {
        return this.metrics;
    }

    public VisorSpisConfiguration spis() {
        return this.spis;
    }

    public VisorPeerToPeerConfiguration p2p() {
        return this.p2p;
    }

    public VisorLifecycleConfiguration lifecycle() {
        return this.lifecycle;
    }

    public VisorExecutorServiceConfiguration executeService() {
        return this.execSvc;
    }

    public VisorSegmentationConfiguration segmentation() {
        return this.seg;
    }

    public String includeProperties() {
        return this.inclProps;
    }

    public int[] includeEventTypes() {
        return this.inclEvtTypes;
    }

    public VisorRestConfiguration rest() {
        return this.rest;
    }

    public Map<String, ?> userAttributes() {
        return this.userAttrs;
    }

    public Iterable<VisorIgfsConfiguration> igfss() {
        return this.igfss;
    }

    public Map<String, String> env() {
        return this.env;
    }

    public Properties systemProperties() {
        return this.sysProps;
    }

    public VisorAtomicConfiguration atomic() {
        return this.atomic;
    }

    public VisorTransactionConfiguration transaction() {
        return this.txCfg;
    }

    public String toString() {
        return S.toString(VisorGridConfiguration.class, this);
    }
}

