/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.igfs.IgfsIpcEndpointConfiguration;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorIgfsConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private String name;
    private String metaCacheName;
    private String dataCacheName;
    private int blockSize;
    private int prefetchBlocks;
    private int streamBufSize;
    private int perNodeBatchSize;
    private int perNodeParallelBatchCnt;
    private String secondaryHadoopFileSysUri;
    private String secondaryHadoopFileSysCfgPath;
    private String secondaryHadoopFileSysUserName;
    private IgfsMode dfltMode;
    private Map<String, IgfsMode> pathModes;
    private String dualModePutExecutorSrvc;
    private boolean dualModePutExecutorSrvcShutdown;
    private long dualModeMaxPendingPutsSize;
    private long maxTaskRangeLen;
    private int fragmentizerConcurrentFiles;
    private float fragmentizerLocWritesRatio;
    private boolean fragmentizerEnabled;
    private long fragmentizerThrottlingBlockLen;
    private long fragmentizerThrottlingDelay;
    private String ipcEndpointCfg;
    private boolean ipcEndpointEnabled;
    private long maxSpace;
    private int mgmtPort;
    private int seqReadsBeforePrefetch;
    private long trashPurgeTimeout;

    public static VisorIgfsConfiguration from(FileSystemConfiguration igfs) {
        VisorIgfsConfiguration cfg = new VisorIgfsConfiguration();
        cfg.name = igfs.getName();
        cfg.metaCacheName = igfs.getMetaCacheName();
        cfg.dataCacheName = igfs.getDataCacheName();
        cfg.blockSize = igfs.getBlockSize();
        cfg.prefetchBlocks = igfs.getPrefetchBlocks();
        cfg.streamBufSize = igfs.getStreamBufferSize();
        cfg.perNodeBatchSize = igfs.getPerNodeBatchSize();
        cfg.perNodeParallelBatchCnt = igfs.getPerNodeParallelBatchCount();
        cfg.dfltMode = igfs.getDefaultMode();
        cfg.pathModes = igfs.getPathModes();
        cfg.dualModePutExecutorSrvc = VisorTaskUtils.compactClass(igfs.getDualModePutExecutorService());
        cfg.dualModePutExecutorSrvcShutdown = igfs.getDualModePutExecutorServiceShutdown();
        cfg.dualModeMaxPendingPutsSize = igfs.getDualModeMaxPendingPutsSize();
        cfg.maxTaskRangeLen = igfs.getMaximumTaskRangeLength();
        cfg.fragmentizerConcurrentFiles = igfs.getFragmentizerConcurrentFiles();
        cfg.fragmentizerLocWritesRatio = igfs.getFragmentizerLocalWritesRatio();
        cfg.fragmentizerEnabled = igfs.isFragmentizerEnabled();
        cfg.fragmentizerThrottlingBlockLen = igfs.getFragmentizerThrottlingBlockLength();
        cfg.fragmentizerThrottlingDelay = igfs.getFragmentizerThrottlingDelay();
        IgfsIpcEndpointConfiguration endpointCfg = igfs.getIpcEndpointConfiguration();
        cfg.ipcEndpointCfg = endpointCfg != null ? endpointCfg.toString() : null;
        cfg.ipcEndpointEnabled = igfs.isIpcEndpointEnabled();
        cfg.maxSpace = igfs.getMaxSpaceSize();
        cfg.mgmtPort = igfs.getManagementPort();
        cfg.seqReadsBeforePrefetch = igfs.getSequentialReadsBeforePrefetch();
        cfg.trashPurgeTimeout = igfs.getTrashPurgeTimeout();
        return cfg;
    }

    public static Iterable<VisorIgfsConfiguration> list(FileSystemConfiguration[] igfss) {
        if (igfss == null) {
            return Collections.emptyList();
        }
        ArrayList<VisorIgfsConfiguration> cfgs = new ArrayList<VisorIgfsConfiguration>(igfss.length);
        for (FileSystemConfiguration igfs : igfss) {
            cfgs.add(VisorIgfsConfiguration.from(igfs));
        }
        return cfgs;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String metaCacheName() {
        return this.metaCacheName;
    }

    @Nullable
    public String dataCacheName() {
        return this.dataCacheName;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public int prefetchBlocks() {
        return this.prefetchBlocks;
    }

    public int streamBufferSize() {
        return this.streamBufSize;
    }

    public int perNodeBatchSize() {
        return this.perNodeBatchSize;
    }

    public int perNodeParallelBatchCount() {
        return this.perNodeParallelBatchCnt;
    }

    @Nullable
    public String secondaryHadoopFileSystemUri() {
        return this.secondaryHadoopFileSysUri;
    }

    @Nullable
    public String secondaryHadoopFileSystemUserName() {
        return this.secondaryHadoopFileSysUserName;
    }

    @Nullable
    public String secondaryHadoopFileSystemConfigPath() {
        return this.secondaryHadoopFileSysCfgPath;
    }

    public IgfsMode defaultMode() {
        return this.dfltMode;
    }

    @Nullable
    public Map<String, IgfsMode> pathModes() {
        return this.pathModes;
    }

    public String dualModePutExecutorService() {
        return this.dualModePutExecutorSrvc;
    }

    public boolean dualModePutExecutorServiceShutdown() {
        return this.dualModePutExecutorSrvcShutdown;
    }

    public long dualModeMaxPendingPutsSize() {
        return this.dualModeMaxPendingPutsSize;
    }

    public long maxTaskRangeLength() {
        return this.maxTaskRangeLen;
    }

    public int fragmentizerConcurrentFiles() {
        return this.fragmentizerConcurrentFiles;
    }

    public float fragmentizerLocalWritesRatio() {
        return this.fragmentizerLocWritesRatio;
    }

    public boolean fragmentizerEnabled() {
        return this.fragmentizerEnabled;
    }

    public long fragmentizerThrottlingBlockLength() {
        return this.fragmentizerThrottlingBlockLen;
    }

    public long fragmentizerThrottlingDelay() {
        return this.fragmentizerThrottlingDelay;
    }

    @Nullable
    public String ipcEndpointConfiguration() {
        return this.ipcEndpointCfg;
    }

    public boolean ipcEndpointEnabled() {
        return this.ipcEndpointEnabled;
    }

    public long maxSpace() {
        return this.maxSpace;
    }

    public int managementPort() {
        return this.mgmtPort;
    }

    public int sequenceReadsBeforePrefetch() {
        return this.seqReadsBeforePrefetch;
    }

    public long trashPurgeTimeout() {
        return this.trashPurgeTimeout;
    }

    public String toString() {
        return S.toString(VisorIgfsConfiguration.class, this);
    }
}

