/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.igfs.IgfsProcessorAdapter;
import org.apache.ignite.internal.util.ipc.IpcServerEndpoint;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.cache.VisorCache;
import org.apache.ignite.internal.visor.cache.VisorCacheV2;
import org.apache.ignite.internal.visor.cache.VisorCacheV3;
import org.apache.ignite.internal.visor.cache.VisorCacheV4;
import org.apache.ignite.internal.visor.compute.VisorComputeMonitoringHolder;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.igfs.VisorIgfs;
import org.apache.ignite.internal.visor.igfs.VisorIgfsEndpoint;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJobResult;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskArg;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteProductVersion;

public class VisorNodeDataCollectorJob
extends VisorJob<VisorNodeDataCollectorTaskArg, VisorNodeDataCollectorJobResult> {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion VER_1_4_1 = IgniteProductVersion.fromString("1.4.1");
    private static final IgniteProductVersion VER_1_5_10 = IgniteProductVersion.fromString("1.5.10");
    private static final IgniteProductVersion VER_1_5_26 = IgniteProductVersion.fromString("1.5.26");
    protected static final IgniteProductVersion VER_1_7_2 = IgniteProductVersion.fromString("1.7.2");

    public VisorNodeDataCollectorJob(VisorNodeDataCollectorTaskArg arg, boolean debug) {
        super(arg, debug);
    }

    protected void events0(VisorNodeDataCollectorJobResult res, String evtOrderKey, String evtThrottleCntrKey, boolean all) {
        res.events().addAll(VisorTaskUtils.collectEvents((Ignite)this.ignite, evtOrderKey, evtThrottleCntrKey, all, (IgniteClosure<Event, VisorGridEvent>)(this.compatibleWith(VER_1_7_2) ? VisorTaskUtils.EVT_MAPPER_V2 : VisorTaskUtils.EVT_MAPPER)));
    }

    protected void events(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        try {
            if (VisorTaskUtils.checkExplicitTaskMonitoring(this.ignite)) {
                res.taskMonitoringEnabled(true);
            } else {
                res.taskMonitoringEnabled(arg.taskMonitoringEnabled());
                if (arg.taskMonitoringEnabled()) {
                    ConcurrentMap<String, VisorComputeMonitoringHolder> storage = this.ignite.cluster().nodeLocalMap();
                    VisorComputeMonitoringHolder holder = (VisorComputeMonitoringHolder)storage.get("VISOR_COMPUTE_MONITORING_KEY");
                    if (holder == null) {
                        VisorComputeMonitoringHolder holderNew = new VisorComputeMonitoringHolder();
                        VisorComputeMonitoringHolder holderOld = storage.putIfAbsent("VISOR_COMPUTE_MONITORING_KEY", holderNew);
                        holder = holderOld == null ? holderNew : holderOld;
                    }
                    holder.startCollect(this.ignite, arg.eventsOrderKey());
                    res.taskMonitoringEnabled(this.ignite.allEventsUserRecordable(VisorTaskUtils.VISOR_TASK_EVTS));
                }
            }
            this.events0(res, arg.eventsOrderKey(), arg.eventsThrottleCounterKey(), arg.taskMonitoringEnabled());
        }
        catch (Exception eventsEx) {
            res.eventsEx(eventsEx);
        }
    }

    protected boolean compatibleWith(IgniteProductVersion ver) {
        for (ClusterNode node : this.ignite.cluster().nodes()) {
            if (node.version().compareToIgnoreTimestamp(ver) > 0) continue;
            return true;
        }
        return false;
    }

    private VisorCache createVisorCache() {
        if (this.compatibleWith(VER_1_4_1)) {
            return new VisorCache();
        }
        if (this.compatibleWith(VER_1_5_10)) {
            return new VisorCacheV2();
        }
        if (this.compatibleWith(VER_1_5_26)) {
            return new VisorCacheV3();
        }
        return new VisorCacheV4();
    }

    private boolean proxyCache(String cacheName) {
        ClusterNode locNode;
        GridDiscoveryManager discovery = this.ignite.context().discovery();
        return !discovery.cacheAffinityNode(locNode = this.ignite.localNode(), cacheName) && !discovery.cacheNearNode(locNode, cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void caches(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        try {
            IgniteConfiguration cfg = this.ignite.configuration();
            for (String cacheName : this.ignite.context().cache().cacheNames()) {
                if (this.proxyCache(cacheName) || !arg.systemCaches() && (GridCacheUtils.isSystemCache(cacheName) || GridCacheUtils.isIgfsCache(cfg, cacheName))) continue;
                long start0 = U.currentTimeMillis();
                try {
                    VisorCache cache = this.createVisorCache().from(this.ignite, cacheName, arg.sample());
                    if (cache == null) continue;
                    res.caches().add(cache);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    if (!this.debug || this.ignite.log() == null) continue;
                    this.ignite.log().error("Ignored cache: " + cacheName, e);
                }
                finally {
                    if (!this.debug) continue;
                    VisorTaskUtils.log(this.ignite.log(), "Collected cache: " + cacheName, this.getClass(), start0);
                }
            }
        }
        catch (Exception cachesEx) {
            res.cachesEx(cachesEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void igfs(VisorNodeDataCollectorJobResult res) {
        try {
            IgfsProcessorAdapter igfsProc = this.ignite.context().igfs();
            for (IgniteFileSystem igfs : igfsProc.igfss()) {
                long start0 = U.currentTimeMillis();
                FileSystemConfiguration igfsCfg = igfs.configuration();
                if (this.proxyCache(igfsCfg.getDataCacheName()) || this.proxyCache(igfsCfg.getMetaCacheName())) continue;
                try {
                    Collection<IpcServerEndpoint> endPoints = igfsProc.endpoints(igfs.name());
                    if (endPoints != null) {
                        for (IpcServerEndpoint ep : endPoints) {
                            if (!ep.isManagement()) continue;
                            res.igfsEndpoints().add(new VisorIgfsEndpoint(igfs.name(), this.ignite.name(), ep.getHost(), ep.getPort()));
                        }
                    }
                    res.igfss().add(VisorIgfs.from(igfs));
                }
                finally {
                    if (!this.debug) continue;
                    VisorTaskUtils.log(this.ignite.log(), "Collected IGFS: " + igfs.name(), this.getClass(), start0);
                }
            }
        }
        catch (Exception igfssEx) {
            res.igfssEx(igfssEx);
        }
    }

    @Override
    protected VisorNodeDataCollectorJobResult run(VisorNodeDataCollectorTaskArg arg) {
        return this.run(new VisorNodeDataCollectorJobResult(), arg);
    }

    protected VisorNodeDataCollectorJobResult run(VisorNodeDataCollectorJobResult res, VisorNodeDataCollectorTaskArg arg) {
        res.gridName(this.ignite.name());
        res.topologyVersion(this.ignite.cluster().topologyVersion());
        long start0 = U.currentTimeMillis();
        this.events(res, arg);
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected events", this.getClass(), start0);
        }
        this.caches(res, arg);
        if (this.debug) {
            start0 = VisorTaskUtils.log(this.ignite.log(), "Collected caches", this.getClass(), start0);
        }
        this.igfs(res);
        if (this.debug) {
            VisorTaskUtils.log(this.ignite.log(), "Collected igfs", this.getClass(), start0);
        }
        res.errorCount(this.ignite.context().exceptionRegistry().errorCount());
        return res;
    }

    public String toString() {
        return S.toString(VisorNodeDataCollectorJob.class, this);
    }
}

