/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJob;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJobResult;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskArg;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskResult;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodeDataCollectorTask
extends VisorMultiNodeTask<VisorNodeDataCollectorTaskArg, VisorNodeDataCollectorTaskResult, VisorNodeDataCollectorJobResult> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeDataCollectorJob job(VisorNodeDataCollectorTaskArg arg) {
        return new VisorNodeDataCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorNodeDataCollectorTaskResult reduce0(List<ComputeJobResult> results) {
        return this.reduce(new VisorNodeDataCollectorTaskResult(), results);
    }

    protected VisorNodeDataCollectorTaskResult reduce(VisorNodeDataCollectorTaskResult taskRes, List<ComputeJobResult> results) {
        for (ComputeJobResult res : results) {
            VisorNodeDataCollectorJobResult jobRes = (VisorNodeDataCollectorJobResult)res.getData();
            if (jobRes == null) continue;
            UUID nid = res.getNode().id();
            IgniteException unhandledEx = res.getException();
            if (unhandledEx == null) {
                this.reduceJobResult(taskRes, jobRes, nid);
                continue;
            }
            if (unhandledEx instanceof ClusterGroupEmptyException) continue;
            taskRes.unhandledEx().put(nid, new VisorExceptionWrapper(unhandledEx));
        }
        return taskRes;
    }

    protected void reduceJobResult(VisorNodeDataCollectorTaskResult taskRes, VisorNodeDataCollectorJobResult jobRes, UUID nid) {
        taskRes.gridNames().put(nid, jobRes.gridName());
        taskRes.topologyVersions().put(nid, jobRes.topologyVersion());
        taskRes.taskMonitoringEnabled().put(nid, jobRes.taskMonitoringEnabled());
        taskRes.errorCounts().put(nid, jobRes.errorCount());
        if (!jobRes.events().isEmpty()) {
            taskRes.events().addAll(jobRes.events());
        }
        if (jobRes.eventsEx() != null) {
            taskRes.eventsEx().put(nid, new VisorExceptionWrapper(jobRes.eventsEx()));
        }
        if (!jobRes.caches().isEmpty()) {
            taskRes.caches().put(nid, jobRes.caches());
        }
        if (jobRes.cachesEx() != null) {
            taskRes.cachesEx().put(nid, new VisorExceptionWrapper(jobRes.cachesEx()));
        }
        if (!jobRes.igfss().isEmpty()) {
            taskRes.igfss().put(nid, jobRes.igfss());
        }
        if (!jobRes.igfsEndpoints().isEmpty()) {
            taskRes.igfsEndpoints().put(nid, jobRes.igfsEndpoints());
        }
        if (jobRes.igfssEx() != null) {
            taskRes.igfssEx().put(nid, new VisorExceptionWrapper(jobRes.igfssEx()));
        }
    }
}

