/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.util.VisorEventMapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodeEventsCollectorTask
extends VisorMultiNodeTask<VisorNodeEventsCollectorTaskArg, Iterable<? extends VisorGridEvent>, Collection<? extends VisorGridEvent>> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeEventsCollectorJob job(VisorNodeEventsCollectorTaskArg arg) {
        return new VisorNodeEventsCollectorJob(arg, this.debug);
    }

    @Override
    protected Iterable<? extends VisorGridEvent> reduce0(List<ComputeJobResult> results) {
        ArrayList allEvts = new ArrayList();
        for (ComputeJobResult r : results) {
            if (r.getException() != null) continue;
            allEvts.addAll((Collection)r.getData());
        }
        return allEvts.isEmpty() ? Collections.emptyList() : allEvts;
    }

    protected static class VisorNodeEventsCollectorJob
    extends VisorJob<VisorNodeEventsCollectorTaskArg, Collection<? extends VisorGridEvent>> {
        private static final long serialVersionUID = 0L;

        protected VisorNodeEventsCollectorJob(VisorNodeEventsCollectorTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private boolean containsInTaskName(String taskName, String taskClsName, String s) {
            assert (taskName != null);
            assert (taskClsName != null);
            if (taskName.equals(taskClsName)) {
                int idx = taskName.lastIndexOf(46);
                return (idx >= 0 ? taskName.substring(idx + 1) : taskName).toLowerCase().contains(s);
            }
            return taskName.toLowerCase().contains(s);
        }

        private boolean filterByTaskName(Event e, String taskName) {
            String compareTaskName = taskName.toLowerCase();
            if (e.getClass().equals(TaskEvent.class)) {
                TaskEvent te = (TaskEvent)e;
                return this.containsInTaskName(te.taskName(), te.taskClassName(), compareTaskName);
            }
            if (e.getClass().equals(JobEvent.class)) {
                JobEvent je = (JobEvent)e;
                return this.containsInTaskName(je.taskName(), je.taskName(), compareTaskName);
            }
            if (e.getClass().equals(DeploymentEvent.class)) {
                DeploymentEvent de = (DeploymentEvent)e;
                return de.alias().toLowerCase().contains(compareTaskName);
            }
            return true;
        }

        private boolean filterByTaskSessionId(Event e, IgniteUuid taskSesId) {
            if (e.getClass().equals(TaskEvent.class)) {
                TaskEvent te = (TaskEvent)e;
                return te.taskSessionId().equals(taskSesId);
            }
            if (e.getClass().equals(JobEvent.class)) {
                JobEvent je = (JobEvent)e;
                return je.taskSessionId().equals(taskSesId);
            }
            return true;
        }

        protected VisorEventMapper eventMapper() {
            return VisorTaskUtils.EVT_MAPPER;
        }

        @Override
        protected Collection<? extends VisorGridEvent> run(final VisorNodeEventsCollectorTaskArg arg) {
            final long startEvtTime = arg.timeArgument() == null ? 0L : System.currentTimeMillis() - arg.timeArgument();
            ConcurrentMap<String, Long> nl = this.ignite.cluster().nodeLocalMap();
            final Long startEvtOrder = arg.keyOrder() != null && nl.containsKey(arg.keyOrder()) ? (Long)nl.get(arg.keyOrder()) : -1L;
            Collection<Event> evts = this.ignite.events().localQuery(new IgnitePredicate<Event>(){
                private static final long serialVersionUID = 0L;

                @Override
                public boolean apply(Event evt) {
                    return !(evt.localOrder() <= startEvtOrder || arg.typeArgument() != null && !F.contains(arg.typeArgument(), evt.type()) || evt.timestamp() < startEvtTime || arg.taskName() != null && !VisorNodeEventsCollectorJob.this.filterByTaskName(evt, arg.taskName()) || arg.taskSessionId() != null && !VisorNodeEventsCollectorJob.this.filterByTaskSessionId(evt, arg.taskSessionId()));
                }
            }, new int[0]);
            ArrayList<VisorGridEvent> res = new ArrayList<VisorGridEvent>(evts.size());
            Long maxOrder = startEvtOrder;
            VisorEventMapper mapper = this.eventMapper();
            for (Event e : evts) {
                maxOrder = Math.max(maxOrder, e.localOrder());
                VisorGridEvent visorEvt = (VisorGridEvent)mapper.apply(e);
                if (visorEvt != null) {
                    res.add(visorEvt);
                    continue;
                }
                res.add(new VisorGridEvent(e.type(), e.id(), e.name(), e.node().id(), e.timestamp(), e.message(), e.shortDisplay()));
            }
            if (arg.keyOrder() != null && !res.isEmpty()) {
                nl.put(arg.keyOrder(), maxOrder);
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorNodeEventsCollectorJob.class, this);
        }
    }

    public static class VisorNodeEventsCollectorTaskArg
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String keyOrder;
        private final int[] typeArg;
        private final Long timeArg;
        private final String taskName;
        private final IgniteUuid taskSesId;

        public VisorNodeEventsCollectorTaskArg(@Nullable String keyOrder, @Nullable int[] typeArg, @Nullable Long timeArg, @Nullable String taskName, @Nullable IgniteUuid taskSesId) {
            this.keyOrder = keyOrder;
            this.typeArg = typeArg;
            this.timeArg = timeArg;
            this.taskName = taskName;
            this.taskSesId = taskSesId;
        }

        public static VisorNodeEventsCollectorTaskArg createEventsArg(@Nullable int[] typeArg, @Nullable Long timeArg) {
            return new VisorNodeEventsCollectorTaskArg(null, typeArg, timeArg, null, null);
        }

        public static VisorNodeEventsCollectorTaskArg createTasksArg(@Nullable Long timeArg, @Nullable String taskName, @Nullable IgniteUuid taskSesId) {
            return new VisorNodeEventsCollectorTaskArg(null, VisorTaskUtils.concat(EventType.EVTS_JOB_EXECUTION, EventType.EVTS_TASK_EXECUTION), timeArg, taskName, taskSesId);
        }

        public static VisorNodeEventsCollectorTaskArg createLogArg(@Nullable String keyOrder, @Nullable int[] typeArg) {
            return new VisorNodeEventsCollectorTaskArg(keyOrder, typeArg, null, null, null);
        }

        @Nullable
        public String keyOrder() {
            return this.keyOrder;
        }

        public int[] typeArgument() {
            return this.typeArg;
        }

        public Long timeArgument() {
            return this.timeArg;
        }

        public String taskName() {
            return this.taskName;
        }

        public IgniteUuid taskSessionId() {
            return this.taskSesId;
        }

        public String toString() {
            return S.toString(VisorNodeEventsCollectorTaskArg.class, this);
        }
    }
}

