/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodeGcTask
extends VisorMultiNodeTask<Void, Map<UUID, IgniteBiTuple<Long, Long>>, IgniteBiTuple<Long, Long>> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeGcJob job(Void arg) {
        return new VisorNodeGcJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, IgniteBiTuple<Long, Long>> reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, IgniteBiTuple<Long, Long>> total = new HashMap<UUID, IgniteBiTuple<Long, Long>>();
        for (ComputeJobResult res : results) {
            IgniteBiTuple jobRes = (IgniteBiTuple)res.getData();
            total.put(res.getNode().id(), jobRes);
        }
        return total;
    }

    private static class VisorNodeGcJob
    extends VisorJob<Void, IgniteBiTuple<Long, Long>> {
        private static final long serialVersionUID = 0L;

        private VisorNodeGcJob(Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IgniteBiTuple<Long, Long> run(Void arg) {
            ClusterNode locNode = this.ignite.localNode();
            long before = this.freeHeap(locNode);
            System.gc();
            return new IgniteBiTuple<Long, Long>(before, this.freeHeap(locNode));
        }

        private long freeHeap(ClusterNode node) {
            ClusterMetrics m = node.metrics();
            return m.getHeapMemoryMaximum() - m.getHeapMemoryUsed();
        }

        public String toString() {
            return S.toString(VisorNodeGcJob.class, this);
        }
    }
}

