/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodePingTask
extends VisorOneNodeTask<UUID, GridTuple3<Boolean, Long, Long>> {
    private static final long serialVersionUID = 0L;

    protected VisorNodePingJob job(UUID arg) {
        return new VisorNodePingJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected GridTuple3<Boolean, Long, Long> reduce0(List<ComputeJobResult> results) {
        try {
            return (GridTuple3)super.reduce0(results);
        }
        catch (ClusterTopologyException ignored) {
            return new GridTuple3<Boolean, Long, Long>(false, -1L, -1L);
        }
    }

    private static class VisorNodePingJob
    extends VisorJob<UUID, GridTuple3<Boolean, Long, Long>> {
        private static final long serialVersionUID = 0L;

        protected VisorNodePingJob(UUID arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected GridTuple3<Boolean, Long, Long> run(UUID nodeToPing) {
            long start = System.currentTimeMillis();
            return new GridTuple3<Boolean, Long, Long>(this.ignite.cluster().pingNode(nodeToPing), start, System.currentTimeMillis());
        }

        public String toString() {
            return S.toString(VisorNodePingJob.class, this);
        }
    }
}

