/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteExceptionRegistry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodeSuppressedErrorsTask
extends VisorMultiNodeTask<Map<UUID, Long>, Map<UUID, IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>>, IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeSuppressedErrorsJob job(Map<UUID, Long> arg) {
        return new VisorNodeSuppressedErrorsJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>> reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>> taskRes = new HashMap<UUID, IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>>(results.size());
        for (ComputeJobResult res : results) {
            IgniteBiTuple jobRes = (IgniteBiTuple)res.getData();
            taskRes.put(res.getNode().id(), jobRes);
        }
        return taskRes;
    }

    private static class VisorNodeSuppressedErrorsJob
    extends VisorJob<Map<UUID, Long>, IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>> {
        private static final long serialVersionUID = 0L;

        private VisorNodeSuppressedErrorsJob(Map<UUID, Long> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>> run(Map<UUID, Long> arg) {
            Long lastOrder = arg.get(this.ignite.localNode().id());
            long order = lastOrder != null ? lastOrder : 0L;
            List<IgniteExceptionRegistry.ExceptionInfo> errors = this.ignite.context().exceptionRegistry().getErrors(order);
            ArrayList<IgniteExceptionRegistry.ExceptionInfo> wrapped = new ArrayList<IgniteExceptionRegistry.ExceptionInfo>(errors.size());
            for (IgniteExceptionRegistry.ExceptionInfo error : errors) {
                if (error.order() > order) {
                    order = error.order();
                }
                wrapped.add(new IgniteExceptionRegistry.ExceptionInfo(error.order(), new VisorExceptionWrapper(error.error()), error.message(), error.threadId(), error.threadName(), error.time()));
            }
            return new IgniteBiTuple<Long, List<IgniteExceptionRegistry.ExceptionInfo>>(order, wrapped);
        }

        public String toString() {
            return S.toString(VisorNodeSuppressedErrorsJob.class, this);
        }
    }
}

