/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorPeerToPeerConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private boolean p2pEnabled;
    private int p2pMissedResCacheSize;
    private String p2pLocClsPathExcl;

    public static VisorPeerToPeerConfiguration from(IgniteConfiguration c) {
        VisorPeerToPeerConfiguration cfg = new VisorPeerToPeerConfiguration();
        cfg.p2pEnabled = c.isPeerClassLoadingEnabled();
        cfg.p2pMissedResCacheSize = c.getPeerClassLoadingMissedResourcesCacheSize();
        cfg.p2pLocClsPathExcl = VisorTaskUtils.compactArray(c.getPeerClassLoadingLocalClassPathExclude());
        return cfg;
    }

    public boolean p2pEnabled() {
        return this.p2pEnabled;
    }

    public int p2pMissedResponseCacheSize() {
        return this.p2pMissedResCacheSize;
    }

    @Nullable
    public String p2pLocalClassPathExclude() {
        return this.p2pLocClsPathExcl;
    }

    public String toString() {
        return S.toString(VisorPeerToPeerConfiguration.class, this);
    }
}

