/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorRestConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private boolean restEnabled;
    private boolean tcpSslEnabled;
    private String[] accessibleFolders;
    private String jettyPath;
    private String jettyHost;
    private Integer jettyPort;
    private String tcpHost;
    private Integer tcpPort;
    private String tcpSslCtxFactory;

    public static VisorRestConfiguration from(IgniteConfiguration c) {
        boolean restEnabled;
        VisorRestConfiguration cfg = new VisorRestConfiguration();
        ConnectorConfiguration clnCfg = c.getConnectorConfiguration();
        cfg.restEnabled = restEnabled = clnCfg != null;
        if (restEnabled) {
            cfg.tcpSslEnabled = clnCfg.isSslEnabled();
            cfg.jettyPath = clnCfg.getJettyPath();
            cfg.jettyHost = System.getProperty("IGNITE_JETTY_HOST");
            cfg.jettyPort = VisorTaskUtils.intValue("IGNITE_JETTY_PORT", null);
            cfg.tcpHost = clnCfg.getHost();
            cfg.tcpPort = clnCfg.getPort();
            cfg.tcpSslCtxFactory = VisorTaskUtils.compactClass(clnCfg.getSslContextFactory());
        }
        return cfg;
    }

    public boolean restEnabled() {
        return this.restEnabled;
    }

    public boolean tcpSslEnabled() {
        return this.tcpSslEnabled;
    }

    @Nullable
    public String[] accessibleFolders() {
        return this.accessibleFolders;
    }

    @Nullable
    public String jettyPath() {
        return this.jettyPath;
    }

    @Nullable
    public String jettyHost() {
        return this.jettyHost;
    }

    @Nullable
    public Integer jettyPort() {
        return this.jettyPort;
    }

    @Nullable
    public String tcpHost() {
        return this.tcpHost;
    }

    @Nullable
    public Integer tcpPort() {
        return this.tcpPort;
    }

    @Nullable
    public String tcpSslContextFactory() {
        return this.tcpSslCtxFactory;
    }

    public String toString() {
        return S.toString(VisorRestConfiguration.class, this);
    }
}

