/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.jetbrains.annotations.Nullable;

public class VisorSegmentationConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private SegmentationPolicy plc;
    private String resolvers;
    private long checkFreq;
    private boolean waitOnStart;
    private boolean passRequired;

    public static VisorSegmentationConfiguration from(IgniteConfiguration c) {
        VisorSegmentationConfiguration cfg = new VisorSegmentationConfiguration();
        cfg.plc = c.getSegmentationPolicy();
        cfg.resolvers = VisorTaskUtils.compactArray(c.getSegmentationResolvers());
        cfg.checkFreq = c.getSegmentCheckFrequency();
        cfg.waitOnStart = c.isWaitForSegmentOnStart();
        cfg.passRequired = c.isAllSegmentationResolversPassRequired();
        return cfg;
    }

    public SegmentationPolicy policy() {
        return this.plc;
    }

    @Nullable
    public String resolvers() {
        return this.resolvers;
    }

    public long checkFrequency() {
        return this.checkFreq;
    }

    public boolean waitOnStart() {
        return this.waitOnStart;
    }

    public boolean passRequired() {
        return this.passRequired;
    }

    public String toString() {
        return S.toString(VisorSegmentationConfiguration.class, this);
    }
}

