/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiConfiguration;

public class VisorSpisConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private IgniteBiTuple<String, Map<String, Object>> discoSpi;
    private IgniteBiTuple<String, Map<String, Object>> commSpi;
    private IgniteBiTuple<String, Map<String, Object>> evtSpi;
    private IgniteBiTuple<String, Map<String, Object>> colSpi;
    private IgniteBiTuple<String, Map<String, Object>> deploySpi;
    private IgniteBiTuple<String, Map<String, Object>>[] cpSpis;
    private IgniteBiTuple<String, Map<String, Object>>[] failSpis;
    private IgniteBiTuple<String, Map<String, Object>>[] loadBalancingSpis;
    private IgniteBiTuple<String, Map<String, Object>> swapSpaceSpis;
    private IgniteBiTuple<String, Map<String, Object>>[] indexingSpis;

    private static IgniteBiTuple<String, Map<String, Object>> collectSpiInfo(IgniteSpi spi) {
        Class<?> spiCls = spi.getClass();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("Class Name", VisorTaskUtils.compactClass(spi));
        block5: for (Method mtd : spiCls.getDeclaredMethods()) {
            String mtdName;
            if (!mtd.isAnnotationPresent(IgniteSpiConfiguration.class) || mtd.isAnnotationPresent(Deprecated.class) || !(mtdName = mtd.getName()).startsWith("set")) continue;
            String propName = Character.toLowerCase(mtdName.charAt(3)) + mtdName.substring(4);
            String[] getterNames = new String[]{"get" + mtdName.substring(3), "is" + mtdName.substring(3), "get" + mtdName.substring(3) + "Formatted"};
            try {
                for (String getterName : getterNames) {
                    try {
                        Method getter = spiCls.getDeclaredMethod(getterName, new Class[0]);
                        Object getRes = getter.invoke((Object)spi, new Object[0]);
                        res.put(propName, VisorTaskUtils.compactObject(getRes));
                        continue block5;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (IllegalAccessException ignored) {
                res.put(propName, "Error: Method Cannot Be Accessed");
            }
            catch (InvocationTargetException ite) {
                res.put(propName, "Error: Method Threw An Exception: " + ite);
            }
        }
        return new IgniteBiTuple<String, Map<String, Object>>(spi.getName(), res);
    }

    private static IgniteBiTuple<String, Map<String, Object>>[] collectSpiInfo(IgniteSpi[] spis) {
        IgniteBiTuple[] res = new IgniteBiTuple[spis.length];
        for (int i = 0; i < spis.length; ++i) {
            res[i] = VisorSpisConfiguration.collectSpiInfo(spis[i]);
        }
        return res;
    }

    public static VisorSpisConfiguration from(IgniteConfiguration c) {
        VisorSpisConfiguration cfg = new VisorSpisConfiguration();
        cfg.discoSpi = VisorSpisConfiguration.collectSpiInfo(c.getDiscoverySpi());
        cfg.commSpi = VisorSpisConfiguration.collectSpiInfo(c.getCommunicationSpi());
        cfg.evtSpi = VisorSpisConfiguration.collectSpiInfo(c.getEventStorageSpi());
        cfg.colSpi = VisorSpisConfiguration.collectSpiInfo(c.getCollisionSpi());
        cfg.deploySpi = VisorSpisConfiguration.collectSpiInfo(c.getDeploymentSpi());
        cfg.cpSpis = VisorSpisConfiguration.collectSpiInfo(c.getCheckpointSpi());
        cfg.failSpis = VisorSpisConfiguration.collectSpiInfo(c.getFailoverSpi());
        cfg.loadBalancingSpis = VisorSpisConfiguration.collectSpiInfo(c.getLoadBalancingSpi());
        cfg.swapSpaceSpis = VisorSpisConfiguration.collectSpiInfo(c.getSwapSpaceSpi());
        cfg.indexingSpis = F.asArray(VisorSpisConfiguration.collectSpiInfo(c.getIndexingSpi()));
        return cfg;
    }

    public IgniteBiTuple<String, Map<String, Object>> discoverySpi() {
        return this.discoSpi;
    }

    public IgniteBiTuple<String, Map<String, Object>> communicationSpi() {
        return this.commSpi;
    }

    public IgniteBiTuple<String, Map<String, Object>> eventStorageSpi() {
        return this.evtSpi;
    }

    public IgniteBiTuple<String, Map<String, Object>> collisionSpi() {
        return this.colSpi;
    }

    public IgniteBiTuple<String, Map<String, Object>> deploymentSpi() {
        return this.deploySpi;
    }

    public IgniteBiTuple<String, Map<String, Object>>[] checkpointSpis() {
        return this.cpSpis;
    }

    public IgniteBiTuple<String, Map<String, Object>>[] failoverSpis() {
        return this.failSpis;
    }

    public IgniteBiTuple<String, Map<String, Object>>[] loadBalancingSpis() {
        return this.loadBalancingSpis;
    }

    public IgniteBiTuple<String, Map<String, Object>> swapSpaceSpi() {
        return this.swapSpaceSpis;
    }

    public IgniteBiTuple<String, Map<String, Object>>[] indexingSpis() {
        return this.indexingSpis;
    }

    public String toString() {
        return S.toString(VisorSpisConfiguration.class, this);
    }
}

