/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.Serializable;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.LessNamingBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class VisorTransactionConfiguration
implements Serializable,
LessNamingBean {
    private static final long serialVersionUID = 0L;
    private TransactionConcurrency dfltTxConcurrency;
    private TransactionIsolation dfltTxIsolation;
    private long dfltTxTimeout;
    private int pessimisticTxLogLinger;
    private int pessimisticTxLogSize;
    private boolean txSerEnabled;

    public static VisorTransactionConfiguration from(TransactionConfiguration src) {
        VisorTransactionConfiguration cfg = new VisorTransactionConfiguration();
        cfg.dfltTxConcurrency = src.getDefaultTxConcurrency();
        cfg.dfltTxIsolation = src.getDefaultTxIsolation();
        cfg.dfltTxTimeout = src.getDefaultTxTimeout();
        cfg.pessimisticTxLogLinger = src.getPessimisticTxLogLinger();
        cfg.pessimisticTxLogSize = src.getPessimisticTxLogSize();
        cfg.txSerEnabled = src.isTxSerializableEnabled();
        return cfg;
    }

    public TransactionConcurrency defaultTxConcurrency() {
        return this.dfltTxConcurrency;
    }

    public TransactionIsolation defaultTxIsolation() {
        return this.dfltTxIsolation;
    }

    public long defaultTxTimeout() {
        return this.dfltTxTimeout;
    }

    public int pessimisticTxLogLinger() {
        return this.pessimisticTxLogLinger;
    }

    public int getPessimisticTxLogSize() {
        return this.pessimisticTxLogSize;
    }

    public boolean txSerializableEnabled() {
        return this.txSerEnabled;
    }

    public String toString() {
        return S.toString(VisorTransactionConfiguration.class, this);
    }
}

