/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.query.VisorRunningQuery;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCollectRunningQueriesTask
extends VisorMultiNodeTask<Long, Map<UUID, Collection<VisorRunningQuery>>, Collection<VisorRunningQuery>> {
    private static final long serialVersionUID = 0L;

    protected VisorCollectRunningQueriesJob job(Long arg) {
        return new VisorCollectRunningQueriesJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, Collection<VisorRunningQuery>> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<UUID, Collection<VisorRunningQuery>> map = new HashMap<UUID, Collection<VisorRunningQuery>>();
        for (ComputeJobResult res : results) {
            if (res.getException() != null) continue;
            Collection queries = (Collection)res.getData();
            map.put(res.getNode().id(), queries);
        }
        return map;
    }

    private static class VisorCollectRunningQueriesJob
    extends VisorJob<Long, Collection<VisorRunningQuery>> {
        private static final long serialVersionUID = 0L;

        protected VisorCollectRunningQueriesJob(@Nullable Long arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Collection<VisorRunningQuery> run(@Nullable Long duration) throws IgniteException {
            Collection<GridRunningQueryInfo> queries = this.ignite.context().query().runningQueries(duration != null ? duration : 0L);
            ArrayList<VisorRunningQuery> res = new ArrayList<VisorRunningQuery>(queries.size());
            long curTime = U.currentTimeMillis();
            for (GridRunningQueryInfo qry : queries) {
                res.add(new VisorRunningQuery(qry.id(), qry.query(), qry.queryType(), qry.cache(), qry.startTime(), curTime - qry.startTime(), qry.cancelable(), qry.local()));
            }
            return res;
        }
    }
}

