/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.query.VisorQueryArg;
import org.apache.ignite.internal.visor.query.VisorQueryArgV2;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.query.VisorQueryField;
import org.apache.ignite.internal.visor.query.VisorQueryResultEx;
import org.apache.ignite.internal.visor.query.VisorQueryScanSubstringFilter;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;

public class VisorQueryJob
extends VisorJob<VisorQueryArg, IgniteBiTuple<? extends VisorExceptionWrapper, VisorQueryResultEx>> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryJob(VisorQueryArg arg, boolean debug) {
        super(arg, debug);
    }

    protected IgniteCache<Object, Object> cache(String cacheName) {
        GridCacheProcessor cacheProcessor = this.ignite.context().cache();
        return cacheProcessor.jcache(cacheName);
    }

    private QueryCursor<Cache.Entry<Object, Object>> scan(IgniteCache<Object, Object> c, VisorQueryArg arg, IgniteBiPredicate<Object, Object> filter) {
        ScanQuery<Object, Object> qry = new ScanQuery<Object, Object>(filter);
        qry.setPageSize(arg.pageSize());
        qry.setLocal(arg.local());
        return c.withKeepBinary().query(qry);
    }

    private QueryCursor<Cache.Entry<Object, Object>> near(IgniteCache<Object, Object> c) {
        return new VisorNearCacheCursor<Cache.Entry<Object, Object>>(c.localEntries(CachePeekMode.NEAR).iterator());
    }

    @Override
    protected IgniteBiTuple<? extends VisorExceptionWrapper, VisorQueryResultEx> run(VisorQueryArg arg) {
        try {
            UUID nid = this.ignite.localNode().id();
            String qryTxt = arg.queryTxt();
            boolean scan = qryTxt == null;
            boolean scanWithFilter = qryTxt != null && qryTxt.startsWith("VISOR_SCAN_CACHE_WITH_FILTER");
            boolean near = qryTxt != null && qryTxt.startsWith("VISOR_SCAN_NEAR_CACHE");
            boolean scanAny = scan || scanWithFilter || near;
            String qryId = (scanAny ? "VISOR_SCAN_QUERY" : "VISOR_SQL_QUERY") + "-" + UUID.randomUUID();
            IgniteCache<Object, Object> c = this.cache(arg.cacheName());
            if (scanAny) {
                long start = U.currentTimeMillis();
                VisorQueryScanSubstringFilter filter = null;
                if (scanWithFilter) {
                    boolean caseSensitive = qryTxt.startsWith("VISOR_SCAN_CACHE_WITH_FILTER_CASE_SENSITIVE");
                    String ptrn = caseSensitive ? qryTxt.substring("VISOR_SCAN_CACHE_WITH_FILTER_CASE_SENSITIVE".length()) : qryTxt.substring("VISOR_SCAN_CACHE_WITH_FILTER".length());
                    filter = new VisorQueryScanSubstringFilter(caseSensitive, ptrn);
                }
                VisorQueryCursor<Cache.Entry<Object, Object>> cur = new VisorQueryCursor<Cache.Entry<Object, Object>>(near ? this.near(c) : this.scan(c, arg, filter));
                List<Object[]> rows = VisorQueryUtils.fetchScanQueryRows(cur, arg.pageSize());
                long duration = U.currentTimeMillis() - start;
                boolean hasNext = cur.hasNext();
                if (hasNext) {
                    this.ignite.cluster().nodeLocalMap().put(qryId, cur);
                    this.scheduleResultSetHolderRemoval(qryId);
                } else {
                    cur.close();
                }
                return new IgniteBiTuple<Object, VisorQueryResultEx>(null, new VisorQueryResultEx(nid, qryId, VisorQueryUtils.SCAN_COL_NAMES, rows, hasNext, duration));
            }
            SqlFieldsQuery qry = new SqlFieldsQuery(arg.queryTxt());
            qry.setPageSize(arg.pageSize());
            qry.setLocal(arg.local());
            qry.setDistributedJoins(arg instanceof VisorQueryArgV2 && ((VisorQueryArgV2)arg).distributedJoins());
            long start = U.currentTimeMillis();
            VisorQueryCursor cur = new VisorQueryCursor(c.withKeepBinary().query(qry));
            Collection<GridQueryFieldMetadata> meta = cur.fieldsMeta();
            if (meta == null) {
                return new IgniteBiTuple<VisorExceptionWrapper, Object>(new VisorExceptionWrapper(new SQLException("Fail to execute query. No metadata available.")), null);
            }
            ArrayList<VisorQueryField> names = new ArrayList<VisorQueryField>(meta.size());
            for (GridQueryFieldMetadata col : meta) {
                names.add(new VisorQueryField(col.schemaName(), col.typeName(), col.fieldName(), col.fieldTypeName()));
            }
            List<Object[]> rows = VisorQueryUtils.fetchSqlQueryRows(cur, arg.pageSize());
            long duration = U.currentTimeMillis() - start;
            boolean hasNext = cur.hasNext();
            if (hasNext) {
                this.ignite.cluster().nodeLocalMap().put(qryId, cur);
                this.scheduleResultSetHolderRemoval(qryId);
            } else {
                cur.close();
            }
            return new IgniteBiTuple<Object, VisorQueryResultEx>(null, new VisorQueryResultEx(nid, qryId, names, rows, hasNext, duration));
        }
        catch (Throwable e) {
            return new IgniteBiTuple<VisorExceptionWrapper, Object>(new VisorExceptionWrapper(e), null);
        }
    }

    private void scheduleResultSetHolderRemoval(final String qryId) {
        this.ignite.context().timeout().addTimeoutObject(new GridTimeoutObjectAdapter(VisorQueryUtils.RMV_DELAY.intValue()){

            @Override
            public void onTimeout() {
                ConcurrentMap storage = VisorQueryJob.this.ignite.cluster().nodeLocalMap();
                VisorQueryCursor cur = (VisorQueryCursor)storage.get(qryId);
                if (cur != null) {
                    if (cur.accessed()) {
                        cur.accessed(false);
                        VisorQueryJob.this.scheduleResultSetHolderRemoval(qryId);
                    } else {
                        storage.remove(qryId);
                        cur.close();
                    }
                }
            }
        });
    }

    public String toString() {
        return S.toString(VisorQueryJob.class, this);
    }

    private static class VisorNearCacheCursor<T>
    implements QueryCursor<T> {
        private final Iterator<T> it;

        private VisorNearCacheCursor(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public List<T> getAll() {
            ArrayList<T> all = new ArrayList<T>();
            while (this.it.hasNext()) {
                all.add(this.it.next());
            }
            return all;
        }

        @Override
        public void close() {
        }

        @Override
        public Iterator<T> iterator() {
            return this.it;
        }
    }
}

