/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.lang.IgniteBiTuple;

@GridInternal
public class VisorQueryNextPageTask
extends VisorOneNodeTask<IgniteBiTuple<String, Integer>, VisorQueryResult> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryNextPageJob job(IgniteBiTuple<String, Integer> arg) {
        return new VisorQueryNextPageJob(arg, this.debug);
    }

    private static class VisorQueryNextPageJob
    extends VisorJob<IgniteBiTuple<String, Integer>, VisorQueryResult> {
        private static final long serialVersionUID = 0L;

        private VisorQueryNextPageJob(IgniteBiTuple<String, Integer> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorQueryResult run(IgniteBiTuple<String, Integer> arg) {
            return arg.get1().startsWith("VISOR_SCAN_QUERY") ? this.nextScanPage(arg) : this.nextSqlPage(arg);
        }

        private VisorQueryResult nextSqlPage(IgniteBiTuple<String, Integer> arg) {
            String qryId;
            long start = U.currentTimeMillis();
            ConcurrentMap storage = this.ignite.cluster().nodeLocalMap();
            VisorQueryCursor cur = (VisorQueryCursor)storage.get(qryId = arg.get1());
            if (cur == null) {
                throw new IgniteException("SQL query results are expired.");
            }
            List<Object[]> nextRows = VisorQueryUtils.fetchSqlQueryRows(cur, arg.get2());
            boolean hasMore = cur.hasNext();
            if (hasMore) {
                cur.accessed(true);
            } else {
                storage.remove(qryId);
                cur.close();
            }
            return new VisorQueryResult(nextRows, hasMore, U.currentTimeMillis() - start);
        }

        private VisorQueryResult nextScanPage(IgniteBiTuple<String, Integer> arg) {
            String qryId;
            long start = U.currentTimeMillis();
            ConcurrentMap storage = this.ignite.cluster().nodeLocalMap();
            VisorQueryCursor cur = (VisorQueryCursor)storage.get(qryId = arg.get1());
            if (cur == null) {
                throw new IgniteException("Scan query results are expired.");
            }
            List<Object[]> rows = VisorQueryUtils.fetchScanQueryRows(cur, arg.get2());
            boolean hasMore = cur.hasNext();
            if (hasMore) {
                cur.accessed(true);
            } else {
                storage.remove(qryId);
                cur.close();
            }
            return new VisorQueryResult(rows, hasMore, U.currentTimeMillis() - start);
        }

        public String toString() {
            return S.toString(VisorQueryNextPageJob.class, this);
        }
    }
}

