/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.query.VisorQueryField;

public class VisorQueryUtils {
    public static final Integer RMV_DELAY = 300000;
    public static final String SQL_QRY_NAME = "VISOR_SQL_QUERY";
    public static final String SCAN_QRY_NAME = "VISOR_SCAN_QUERY";
    public static final String SCAN_NEAR_CACHE = "VISOR_SCAN_NEAR_CACHE";
    public static final String SCAN_CACHE_WITH_FILTER = "VISOR_SCAN_CACHE_WITH_FILTER";
    public static final String SCAN_CACHE_WITH_FILTER_CASE_SENSITIVE = "VISOR_SCAN_CACHE_WITH_FILTER_CASE_SENSITIVE";
    public static final Collection<VisorQueryField> SCAN_COL_NAMES = Arrays.asList(new VisorQueryField(null, null, "Key Class", ""), new VisorQueryField(null, null, "Key", ""), new VisorQueryField(null, null, "Value Class", ""), new VisorQueryField(null, null, "Value", ""));

    private static String typeOf(Object o) {
        if (o != null) {
            Class<?> clazz = o.getClass();
            return clazz.isArray() ? IgniteUtils.compact(clazz.getComponentType().getName()) + "[]" : IgniteUtils.compact(o.getClass().getName());
        }
        return "n/a";
    }

    private static String valueOf(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof byte[]) {
            return "size=" + ((byte[])o).length;
        }
        if (o instanceof Byte[]) {
            return "size=" + ((Byte[])o).length;
        }
        if (o instanceof Object[]) {
            return "size=" + ((Object[])o).length + ", values=[" + VisorQueryUtils.mkString((Object[])o, 120) + "]";
        }
        if (o instanceof BinaryObject) {
            return VisorQueryUtils.binaryToString((BinaryObject)o);
        }
        return o.toString();
    }

    private static String mkString(Object[] arr, int maxSz) {
        String sep = ", ";
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object v : arr) {
            if (first) {
                first = false;
            } else {
                sb.append(sep);
            }
            sb.append(v);
            if (sb.length() > maxSz) break;
        }
        if (sb.length() >= maxSz) {
            String end = "...";
            sb.setLength(maxSz - end.length());
            sb.append(end);
        }
        return sb.toString();
    }

    public static List<Object[]> fetchScanQueryRows(VisorQueryCursor<Cache.Entry<Object, Object>> cur, int pageSize) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (int cnt = 0; cur.hasNext() && cnt < pageSize; ++cnt) {
            Cache.Entry<Object, Object> next = cur.next();
            Object k = next.getKey();
            Object v = next.getValue();
            rows.add(new Object[]{VisorQueryUtils.typeOf(k), VisorQueryUtils.valueOf(k), VisorQueryUtils.typeOf(v), VisorQueryUtils.valueOf(v)});
        }
        return rows;
    }

    private static boolean isKnownType(Object obj) {
        return obj instanceof String || obj instanceof Boolean || obj instanceof Byte || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof Date || obj instanceof Double || obj instanceof Float || obj instanceof BigDecimal || obj instanceof URL;
    }

    public static String binaryToString(BinaryObject obj) {
        int hash = obj.hashCode();
        if (obj instanceof BinaryObjectEx) {
            BinaryType meta;
            BinaryObjectEx objEx = (BinaryObjectEx)obj;
            try {
                meta = ((BinaryObjectEx)obj).rawType();
            }
            catch (BinaryObjectException ignore) {
                meta = null;
            }
            if (meta != null) {
                SB buf = new SB(meta.typeName());
                if (meta.fieldNames() != null) {
                    buf.a(" [hash=").a(hash);
                    for (String name : meta.fieldNames()) {
                        Object val = objEx.field(name);
                        buf.a(", ").a(name).a('=').a(val);
                    }
                    buf.a(']');
                    return buf.toString();
                }
            }
        }
        return S.toString(obj.getClass().getSimpleName(), "hash", hash, false, "typeId", obj.type().typeId(), true);
    }

    public static List<Object[]> fetchSqlQueryRows(VisorQueryCursor<List<?>> cur, int pageSize) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (int cnt = 0; cur.hasNext() && cnt < pageSize; ++cnt) {
            List<?> next = cur.next();
            int sz = next.size();
            Object[] row = new Object[sz];
            for (int i = 0; i < sz; ++i) {
                Object o = next.get(i);
                row[i] = o == null ? null : (VisorQueryUtils.isKnownType(o) ? o : (o instanceof BinaryObject ? VisorQueryUtils.binaryToString((BinaryObject)o) : (o.getClass().isArray() ? "binary" : o.toString())));
            }
            rows.add(row);
        }
        return rows;
    }
}

