/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.service;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.services.ServiceDescriptor;

public class VisorServiceDescriptor
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private String srvcCls;
    private int totalCnt;
    private int maxPerNodeCnt;
    private String cacheName;
    private UUID originNodeId;
    private Map<UUID, Integer> topSnapshot;

    public VisorServiceDescriptor() {
    }

    public VisorServiceDescriptor(ServiceDescriptor srvc) {
        this.name = srvc.name();
        this.srvcCls = VisorTaskUtils.compactClass(srvc.serviceClass());
        this.totalCnt = srvc.totalCount();
        this.maxPerNodeCnt = srvc.maxPerNodeCount();
        this.cacheName = srvc.cacheName();
        this.originNodeId = srvc.originNodeId();
        this.topSnapshot = srvc.topologySnapshot();
    }

    public String getName() {
        return this.name;
    }

    public String getServiceClass() {
        return this.srvcCls;
    }

    public int getTotalCnt() {
        return this.totalCnt;
    }

    public int getMaxPerNodeCnt() {
        return this.maxPerNodeCnt;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public UUID getOriginNodeId() {
        return this.originNodeId;
    }

    public Map<UUID, Integer> getTopologySnapshot() {
        return this.topSnapshot;
    }

    public String toString() {
        return S.toString(VisorServiceDescriptor.class, this);
    }
}

