/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.util;

public class VisorExceptionWrapper
extends Throwable {
    private static final long serialVersionUID = 0L;
    private String detailMsg;
    private String clsSimpleName;
    private String clsName;

    public VisorExceptionWrapper(Throwable cause) {
        assert (cause != null);
        this.clsSimpleName = cause.getClass().getSimpleName();
        this.clsName = cause.getClass().getName();
        this.detailMsg = cause.getMessage();
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (stackTrace != null) {
            this.setStackTrace(stackTrace);
        }
        if (cause.getCause() != null) {
            this.initCause(new VisorExceptionWrapper(cause.getCause()));
        }
    }

    public String getClassSimpleName() {
        return this.clsSimpleName;
    }

    public String getClassName() {
        return this.clsName;
    }

    @Override
    public String getMessage() {
        return this.detailMsg;
    }

    @Override
    public String toString() {
        return this.detailMsg != null ? this.clsName + ": " + this.detailMsg : this.clsName;
    }
}

