/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import java.util.List;
import java.util.UUID;
import javax.management.JMException;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access to Kernal information.")
public interface IgniteMXBean {
    @MXBeanDescription(value="String presentation of the Ignite version.")
    public String getFullVersion();

    @MXBeanDescription(value="Copyright statement for Ignite product.")
    public String getCopyright();

    @MXBeanDescription(value="String presentation of the kernal start timestamp.")
    public String getStartTimestampFormatted();

    @MXBeanDescription(value="String presentation of up-time for the kernal.")
    public String getUpTimeFormatted();

    @MXBeanDescription(value="Start timestamp of the kernal.")
    public long getStartTimestamp();

    @MXBeanDescription(value="Up-time of the kernal.")
    public long getUpTime();

    @MXBeanDescription(value="Collection of formatted user-defined attributes added to this node.")
    public List<String> getUserAttributesFormatted();

    @MXBeanDescription(value="Formatted instance of logger that is in grid.")
    public String getGridLoggerFormatted();

    @MXBeanDescription(value="Formatted instance of fully configured thread pool that is used in grid.")
    public String getExecutorServiceFormatted();

    @MXBeanDescription(value="Ignite installation home folder.")
    public String getIgniteHome();

    @MXBeanDescription(value="Formatted instance of MBean server instance.")
    public String getMBeanServerFormatted();

    @MXBeanDescription(value="Unique identifier for this node within grid.")
    public UUID getLocalNodeId();

    @MXBeanDescription(value="Whether or not peer class loading (a.k.a. P2P class loading) is enabled.")
    public boolean isPeerClassLoadingEnabled();

    @MXBeanDescription(value="String representation of lifecycle beans.")
    public List<String> getLifecycleBeansFormatted();

    @MXBeanDescription(value="This method allows manually remove the checkpoint with given key. Return true if specified checkpoint was indeed removed, false otherwise.")
    @MXBeanParametersNames(value={"key"})
    @MXBeanParametersDescriptions(value={"Checkpoint key to remove."})
    public boolean removeCheckpoint(String var1);

    @MXBeanDescription(value="Pings node with given node ID to see whether it is alive. Returns whether or not node is alive.")
    @MXBeanParametersNames(value={"nodeId"})
    @MXBeanParametersDescriptions(value={"String presentation of node ID. See java.util.UUID class for details."})
    public boolean pingNode(String var1);

    @MXBeanDescription(value="Makes the best attempt to undeploy a task from the whole grid.")
    @MXBeanParametersNames(value={"taskName"})
    @MXBeanParametersDescriptions(value={"Name of the task to undeploy."})
    public void undeployTaskFromGrid(String var1) throws JMException;

    @MXBeanDescription(value="A shortcut method that executes given task assuming single String argument and String return type. Returns Task return value (assumed of String type).")
    @MXBeanParametersNames(value={"taskName", "arg"})
    @MXBeanParametersDescriptions(value={"Name of the task to execute.", "Single task execution argument (can be null)."})
    public String executeTask(String var1, String var2) throws JMException;

    @MXBeanDescription(value="Pings node with given host name to see if it is alive. Returns whether or not node is alive.")
    @MXBeanParametersNames(value={"host"})
    @MXBeanParametersDescriptions(value={"Host name or IP address of the node to ping."})
    public boolean pingNodeByAddress(String var1);

    @MXBeanDescription(value="Formatted instance of configured discovery SPI implementation.")
    public String getDiscoverySpiFormatted();

    @MXBeanDescription(value="Formatted instance of fully configured SPI communication implementation.")
    public String getCommunicationSpiFormatted();

    @MXBeanDescription(value="Formatted instance of fully configured deployment SPI implementation.")
    public String getDeploymentSpiFormatted();

    @MXBeanDescription(value="Formatted instance of configured checkpoint SPI implementation.")
    public String getCheckpointSpiFormatted();

    @MXBeanDescription(value="Formatted instance of configured collision SPI implementations.")
    public String getCollisionSpiFormatted();

    @MXBeanDescription(value="Formatted instance of configured swapspace SPI implementations.")
    public String getSwapSpaceSpiFormatted();

    @MXBeanDescription(value="Formatted instance of fully configured event SPI implementation.")
    public String getEventStorageSpiFormatted();

    @MXBeanDescription(value="Formatted instance of fully configured failover SPI implementations.")
    public String getFailoverSpiFormatted();

    @MXBeanDescription(value="Formatted instance of fully configured load balancing SPI implementations.")
    public String getLoadBalancingSpiFormatted();

    @MXBeanDescription(value="OS information.")
    public String getOsInformation();

    @MXBeanDescription(value="JDK information.")
    public String getJdkInformation();

    @MXBeanDescription(value="OS user name.")
    public String getOsUser();

    @MXBeanDescription(value="VM name.")
    public String getVmName();

    @MXBeanDescription(value="Optional kernal instance name.")
    public String getInstanceName();

    @MXBeanDescription(value="Prints last suppressed errors.")
    public void printLastErrors();

    @MXBeanDescription(value="Dumps debug information for the current node.")
    public void dumpDebugInfo();
}

