/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.plugin.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.plugin.security.SecurityBasicPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;

public class SecurityPermissionSetBuilder {
    private Map<String, Collection<SecurityPermission>> cachePerms = new HashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> taskPerms = new HashMap<String, Collection<SecurityPermission>>();
    private List<SecurityPermission> sysPerms = new ArrayList<SecurityPermission>();
    private boolean dfltAllowAll;

    public static SecurityPermissionSetBuilder create() {
        return new SecurityPermissionSetBuilder();
    }

    public SecurityPermissionSetBuilder defaultAllowAll(boolean dfltAllowAll) {
        this.dfltAllowAll = dfltAllowAll;
        return this;
    }

    public SecurityPermissionSetBuilder appendTaskPermissions(String name, SecurityPermission ... perms) {
        this.validate(this.toCollection("TASK_"), perms);
        this.append(this.taskPerms, name, this.toCollection(perms));
        return this;
    }

    public SecurityPermissionSetBuilder appendCachePermissions(String name, SecurityPermission ... perms) {
        this.validate(this.toCollection("CACHE_"), perms);
        this.append(this.cachePerms, name, this.toCollection(perms));
        return this;
    }

    public SecurityPermissionSetBuilder appendSystemPermissions(SecurityPermission ... perms) {
        this.validate(this.toCollection("EVENTS_", "ADMIN_"), perms);
        this.sysPerms.addAll(this.toCollection(perms));
        return this;
    }

    private void validate(Collection<String> ptrns, SecurityPermission ... perms) {
        assert (ptrns != null);
        assert (perms != null);
        for (SecurityPermission perm : perms) {
            this.validate(ptrns, perm);
        }
    }

    private void validate(Collection<String> ptrns, SecurityPermission perm) {
        assert (ptrns != null);
        assert (perm != null);
        boolean ex = true;
        String name = perm.name();
        for (String ptrn : ptrns) {
            if (!name.startsWith(ptrn)) continue;
            ex = false;
            break;
        }
        if (ex) {
            throw new IgniteException("you can assign permission only start with " + ptrns + ", but you try " + name);
        }
    }

    @SafeVarargs
    private final <T> Collection<T> toCollection(T ... perms) {
        assert (perms != null);
        ArrayList col = new ArrayList(perms.length);
        Collections.addAll(col, perms);
        return col;
    }

    private void append(Map<String, Collection<SecurityPermission>> permsMap, String name, Collection<SecurityPermission> perms) {
        assert (permsMap != null);
        assert (name != null);
        assert (perms != null);
        Collection<SecurityPermission> col = permsMap.get(name);
        if (col == null) {
            permsMap.put(name, perms);
        } else {
            col.addAll(perms);
        }
    }

    public SecurityPermissionSet build() {
        SecurityBasicPermissionSet permSet = new SecurityBasicPermissionSet();
        permSet.setDefaultAllowAll(this.dfltAllowAll);
        permSet.setCachePermissions(Collections.unmodifiableMap(this.cachePerms));
        permSet.setTaskPermissions(Collections.unmodifiableMap(this.taskPerms));
        permSet.setSystemPermissions(Collections.unmodifiableList(this.sysPerms));
        return permSet;
    }
}

