/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;

public class IgniteSpiOperationTimeoutHelper {
    private long lastOperStartTs;
    private long timeout;
    private final boolean failureDetectionTimeoutEnabled;
    private final long failureDetectionTimeout;

    public IgniteSpiOperationTimeoutHelper(IgniteSpiAdapter adapter) {
        this.failureDetectionTimeoutEnabled = adapter.failureDetectionTimeoutEnabled();
        this.failureDetectionTimeout = adapter.failureDetectionTimeout();
    }

    public long nextTimeoutChunk(long dfltTimeout) throws IgniteSpiOperationTimeoutException {
        if (!this.failureDetectionTimeoutEnabled) {
            return dfltTimeout;
        }
        if (this.lastOperStartTs == 0L) {
            this.timeout = this.failureDetectionTimeout;
            this.lastOperStartTs = U.currentTimeMillis();
        } else {
            long curTs = U.currentTimeMillis();
            this.timeout -= curTs - this.lastOperStartTs;
            this.lastOperStartTs = curTs;
            if (this.timeout <= 0L) {
                throw new IgniteSpiOperationTimeoutException("Network operation timed out. Increase 'failureDetectionTimeout' configuration property [failureDetectionTimeout=" + this.failureDetectionTimeout + ']');
            }
        }
        return this.timeout;
    }

    public boolean checkFailureTimeoutReached(Exception e) {
        if (!this.failureDetectionTimeoutEnabled) {
            return false;
        }
        return e instanceof IgniteSpiOperationTimeoutException || e instanceof SocketTimeoutException || X.hasCause(e, IgniteSpiOperationTimeoutException.class, SocketException.class);
    }
}

