/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.apache.ignite.spi.checkpoint.jdbc.JdbcCheckpointSpiMBean;

@IgniteSpiMultipleInstancesSupport(value=true)
public class JdbcCheckpointSpi
extends IgniteSpiAdapter
implements CheckpointSpi,
JdbcCheckpointSpiMBean {
    public static final int DFLT_NUMBER_OF_RETRIES = 2;
    public static final String DFLT_EXPIRE_DATE_FIELD_TYPE = "DATETIME";
    public static final String DFLT_EXPIRE_DATE_FIELD_NAME = "EXPIRE_DATE";
    public static final String DFLT_VALUE_FIELD_TYPE = "BLOB";
    public static final String DFLT_VALUE_FIELD_NAME = "VALUE";
    public static final String DFLT_KEY_FIELD_TYPE = "VARCHAR(256)";
    public static final String DFLT_KEY_FIELD_NAME = "NAME";
    public static final String DFLT_CHECKPOINT_TABLE_NAME = "CHECKPOINTS";
    private static final long NON_EXPIRABLE_TIMEOUT = 0L;
    private static final String CREATE_TABLE_SQL = "CREATE TABLE {0} ({1} {2} PRIMARY KEY, {3} {4} , {5} {6} NULL)";
    private static final String CHECK_TABLE_EXISTS_SQL = "SELECT 0 FROM {0} WHERE 0 <> 0";
    private static final String CHECK_EXISTS_SQL = "SELECT 0 FROM {0} WHERE {1} = ?";
    private static final String UPDATE_SQL = "UPDATE {0} SET {1} = ?, {2} = ? WHERE {3} = ?";
    private static final String INSERT_SQL = "INSERT INTO {0} ({1}, {2}, {3}) VALUES (?, ?, ?)";
    private static final String DELETE_SQL = "DELETE FROM {0} WHERE {1} = ?";
    private static final String SELECT_SQL = "SELECT {0} FROM {1} WHERE {2} = ? AND ({3} IS NULL OR {3} > ?)";
    private static final String SELECT_EXPIRED_SQL = "SELECT {0} FROM {1} WHERE {2} IS NOT NULL AND {2} <= ?";
    private static final String DELETE_EXPIRED_SQL = "DELETE FROM {0} WHERE {1} IS NOT NULL AND {1} <= ?";
    @LoggerResource
    private IgniteLogger log;
    private DataSource dataSrc;
    private String user;
    private String pwd;
    private int retryNum = 2;
    private String tblName = "CHECKPOINTS";
    private String keyName = "NAME";
    private String keyType = "VARCHAR(256)";
    private String valName = "VALUE";
    private String valType = "BLOB";
    private String expDateName = "EXPIRE_DATE";
    private String expDateType = "DATETIME";
    private String crtTblSql;
    private String chkTblExistsSql;
    private String chkExistsSql;
    private String updateSql;
    private String insSql;
    private String delSql;
    private String selSql;
    private String delExpSql;
    private String selExpSql;
    private CheckpointListener lsnr;

    @Override
    public int getNumberOfRetries() {
        return this.retryNum;
    }

    @Override
    public String getDataSourceInfo() {
        return this.dataSrc.toString();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPwd() {
        return this.pwd;
    }

    @Override
    public String getCheckpointTableName() {
        return this.tblName;
    }

    @Override
    public String getKeyFieldName() {
        return this.keyName;
    }

    @Override
    public String getKeyFieldType() {
        return this.keyType;
    }

    @Override
    public String getValueFieldName() {
        return this.valName;
    }

    @Override
    public String getValueFieldType() {
        return this.valType;
    }

    @Override
    public String getExpireDateFieldName() {
        return this.expDateName;
    }

    @Override
    public String getExpireDateFieldType() {
        return this.expDateType;
    }

    @IgniteSpiConfiguration(optional=false)
    public void setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setNumberOfRetries(int retryNum) {
        this.retryNum = retryNum;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setUser(String user) {
        this.user = user;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setCheckpointTableName(String tblName) {
        this.tblName = tblName;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setKeyFieldName(String keyName) {
        this.keyName = keyName;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setKeyFieldType(String keyType) {
        this.keyType = keyType;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setValueFieldName(String valName) {
        this.valName = valName;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setValueFieldType(String valType) {
        this.valType = valType;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setExpireDateFieldName(String expDateName) {
        this.expDateName = expDateName;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setExpireDateFieldType(String expDateType) {
        this.expDateType = expDateType;
    }

    private String sql(String ptrn, Object ... s) {
        return MessageFormat.format(ptrn, s);
    }

    @Override
    public void spiStart(String gridName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.dataSrc != null, "dataSrc != null");
        this.assertParameter(!F.isEmpty(this.tblName), "!F.isEmpty(tblName)");
        this.assertParameter(!F.isEmpty(this.keyName), "!F.isEmpty(keyName)");
        this.assertParameter(!F.isEmpty(this.keyType), "!F.isEmpty(keyType)");
        this.assertParameter(!F.isEmpty(this.valName), "!F.isEmpty(valName)");
        this.assertParameter(!F.isEmpty(this.valType), "!F.isEmpty(valType)");
        this.assertParameter(!F.isEmpty(this.expDateName), "!F.isEmpty(expDateName)");
        this.assertParameter(!F.isEmpty(this.expDateType), "!F.isEmpty(expDateType)");
        this.crtTblSql = this.sql(CREATE_TABLE_SQL, this.tblName, this.keyName, this.keyType, this.valName, this.valType, this.expDateName, this.expDateType);
        this.chkTblExistsSql = this.sql(CHECK_TABLE_EXISTS_SQL, this.tblName);
        this.chkExistsSql = this.sql(CHECK_EXISTS_SQL, this.tblName, this.keyName);
        this.updateSql = this.sql(UPDATE_SQL, this.tblName, this.valName, this.expDateName, this.keyName);
        this.insSql = this.sql(INSERT_SQL, this.tblName, this.keyName, this.valName, this.expDateName);
        this.delSql = this.sql(DELETE_SQL, this.tblName, this.keyName, this.expDateName);
        this.selSql = this.sql(SELECT_SQL, this.valName, this.tblName, this.keyName, this.expDateName);
        this.delExpSql = this.sql(DELETE_EXPIRED_SQL, this.tblName, this.expDateName);
        this.selExpSql = this.sql(SELECT_EXPIRED_SQL, this.keyName, this.tblName, this.expDateName);
        Connection conn = null;
        try {
            conn = this.getConnection();
            int errCnt = 0;
            while (true) {
                try {
                    if (!this.isCheckpointTableExists(conn)) {
                        this.createCheckpointTable(conn);
                    }
                    conn.commit();
                }
                catch (SQLException e) {
                    U.rollbackConnection(conn, this.log);
                    if (++errCnt >= this.retryNum) {
                        throw new IgniteSpiException("Failed to create checkpoint table: " + this.tblName, e);
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to create checkpoint table as it may already exist (will try again): " + this.tblName);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new IgniteSpiException("Failed to start jdbc checkpoint SPI: " + this.tblName, e);
        }
        finally {
            U.close(conn, this.log);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onContextDestroyed0() {
        if (this.dataSrc != null) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                this.removeExpiredCheckpoints(conn);
                conn.commit();
            }
            catch (SQLException e) {
                U.rollbackConnection(conn, this.log);
                U.error(this.log, "Failed to remove expired checkpoints from: " + this.tblName, e);
            }
            finally {
                U.close(conn, this.log);
            }
        }
    }

    @Override
    public byte[] loadCheckpoint(String key) throws IgniteSpiException {
        byte[] byArray;
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            st = conn.prepareStatement(this.selSql);
            st.setString(1, key);
            st.setTime(2, new Time(U.currentTimeMillis()));
            rs = st.executeQuery();
            byArray = rs.next() ? rs.getBytes(1) : null;
        }
        catch (SQLException e) {
            try {
                throw new IgniteSpiException("Failed to load checkpoint [tblName=" + this.tblName + ", key=" + key + ']', e);
            }
            catch (Throwable throwable) {
                U.close(rs, this.log);
                U.close(st, this.log);
                U.close(conn, this.log);
                throw throwable;
            }
        }
        U.close(rs, this.log);
        U.close(st, this.log);
        U.close(conn, this.log);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCheckpoint(String key) {
        Connection conn = null;
        PreparedStatement st = null;
        boolean rmv = false;
        try {
            conn = this.getConnection();
            st = conn.prepareStatement(this.delSql);
            st.setString(1, key);
            if (st.executeUpdate() > 0) {
                rmv = true;
                CheckpointListener tmp = this.lsnr;
                if (tmp != null) {
                    tmp.onCheckpointRemoved(key);
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            boolean bl;
            try {
                U.rollbackConnection(conn, this.log);
                U.error(this.log, "Failed to remove checkpoint [tblName=" + this.tblName + ", key=" + key + ']', e);
                bl = false;
            }
            catch (Throwable throwable) {
                U.close(st, this.log);
                U.close(conn, this.log);
                throw throwable;
            }
            U.close(st, this.log);
            U.close(conn, this.log);
            return bl;
        }
        U.close(st, this.log);
        U.close(conn, this.log);
        return rmv;
    }

    @Override
    public boolean saveCheckpoint(String key, byte[] state, long timeout, boolean overwrite) throws IgniteSpiException {
        Time expTime = null;
        if (timeout != 0L) {
            expTime = new Time(U.currentTimeMillis() + timeout);
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            int errCnt = 0;
            while (true) {
                block16: {
                    block17: {
                        if (errCnt >= this.retryNum) {
                            throw new IgniteSpiException("Failed to save checkpoint after pre-configured number of retries [tblName=" + this.tblName + ", key=" + key + ", retryNum=" + this.retryNum + ']');
                        }
                        try {
                            if (!this.isCheckpointExists(conn, key)) {
                                if (this.createCheckpoint(conn, key, state, expTime) == 0) {
                                    ++errCnt;
                                    U.warn(this.log, "Failed to create checkpoint (will try again) [tblName=" + this.tblName + ", key=" + key + ']');
                                    continue;
                                }
                                break block16;
                            }
                            if (overwrite) break block17;
                            boolean bl = false;
                            return bl;
                        }
                        catch (SQLException e) {
                            try {
                                U.rollbackConnection(conn, this.log);
                                if (++errCnt >= this.retryNum) {
                                    throw new IgniteSpiException("Failed to save checkpoint [tblName=" + this.tblName + ", key=" + key + ']', e);
                                }
                                U.warn(this.log, "Failed to save checkpoint (will try again) [tblName=" + this.tblName + ", key=" + key + ']');
                                continue;
                            }
                            catch (SQLException e2) {
                                throw new IgniteSpiException("Failed to save checkpoint [tblName=" + this.tblName + ", key=" + key + ']', e2);
                            }
                        }
                    }
                    if (this.updateCheckpoint(conn, key, state, expTime) == 0) {
                        ++errCnt;
                        U.warn(this.log, "Failed to update checkpoint as it may be deleted (will try create) [tblName=" + this.tblName + ", key=" + key + ']');
                        continue;
                    }
                }
                conn.commit();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            U.close(conn, this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCheckpointExists(Connection conn, String key) throws SQLException {
        boolean bl;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = conn.prepareStatement(this.chkExistsSql);
            st.setString(1, key);
            rs = st.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            U.close(rs, this.log);
            U.close(st, this.log);
            throw throwable;
        }
        U.close(rs, this.log);
        U.close(st, this.log);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createCheckpoint(Connection conn, String key, byte[] state, Time expTime) throws SQLException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(this.insSql);
            st.setString(1, key);
            st.setBytes(2, state);
            st.setTime(3, expTime);
            int n = st.executeUpdate();
            return n;
        }
        finally {
            U.close(st, this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateCheckpoint(Connection conn, String key, byte[] state, Time expTime) throws SQLException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(this.updateSql);
            st.setBytes(1, state);
            st.setTime(2, expTime);
            st.setString(3, key);
            int n = st.executeUpdate();
            return n;
        }
        finally {
            U.close(st, this.log);
        }
    }

    private Connection getConnection() throws SQLException {
        Connection conn = this.user != null && this.pwd != null ? this.dataSrc.getConnection(this.user, this.pwd) : this.dataSrc.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCheckpointTableExists(Connection conn) {
        boolean bl;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(this.chkTblExistsSql);
            bl = true;
        }
        catch (SQLException ignored) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                U.close(rs, this.log);
                U.close(st, this.log);
                throw throwable;
            }
            U.close(rs, this.log);
            U.close(st, this.log);
            return bl2;
        }
        U.close(rs, this.log);
        U.close(st, this.log);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheckpointTable(Connection conn) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.executeUpdate(this.crtTblSql);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Successfully created checkpoint table: " + this.tblName);
            }
        }
        finally {
            U.close(st, this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeExpiredCheckpoints(Connection conn) throws SQLException {
        int delCnt = 0;
        PreparedStatement selSt = null;
        PreparedStatement delSt = null;
        ResultSet rs = null;
        Time time = new Time(U.currentTimeMillis());
        CheckpointListener tmp = this.lsnr;
        try {
            if (tmp != null) {
                selSt = conn.prepareStatement(this.selExpSql);
                selSt.setTime(1, time);
                rs = selSt.executeQuery();
                while (rs.next()) {
                    tmp.onCheckpointRemoved(rs.getString(1));
                }
            }
            delSt = conn.prepareStatement(this.delExpSql);
            delSt.setTime(1, time);
            delCnt = delSt.executeUpdate();
        }
        catch (Throwable throwable) {
            U.close(rs, this.log);
            U.close(selSt, this.log);
            U.close(delSt, this.log);
            throw throwable;
        }
        U.close(rs, this.log);
        U.close(selSt, this.log);
        U.close(delSt, this.log);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Successfully removed expired checkpoints from: " + this.tblName);
        }
        return delCnt;
    }

    @Override
    public void setCheckpointListener(CheckpointListener lsnr) {
        this.lsnr = lsnr;
    }
}

