/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.collision.fifoqueue;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.collision.CollisionContext;
import org.apache.ignite.spi.collision.CollisionExternalListener;
import org.apache.ignite.spi.collision.CollisionJobContext;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.spi.collision.fifoqueue.FifoQueueCollisionSpiMBean;

@IgniteSpiMultipleInstancesSupport(value=true)
public class FifoQueueCollisionSpi
extends IgniteSpiAdapter
implements CollisionSpi,
FifoQueueCollisionSpiMBean {
    public static final int DFLT_PARALLEL_JOBS_NUM = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DFLT_WAIT_JOBS_NUM = Integer.MAX_VALUE;
    private volatile int parallelJobsNum = DFLT_PARALLEL_JOBS_NUM;
    private volatile int waitJobsNum = Integer.MAX_VALUE;
    @LoggerResource
    private IgniteLogger log;
    private volatile int runningCnt;
    private volatile int waitingCnt;
    private volatile int heldCnt;

    @Override
    public int getParallelJobsNumber() {
        return this.parallelJobsNum;
    }

    @Override
    @IgniteSpiConfiguration(optional=true)
    public void setParallelJobsNumber(int parallelJobsNum) {
        A.ensure(parallelJobsNum > 0, "parallelJobsNum > 0");
        this.parallelJobsNum = parallelJobsNum;
    }

    @Override
    public int getWaitingJobsNumber() {
        return this.waitJobsNum;
    }

    @Override
    @IgniteSpiConfiguration(optional=true)
    public void setWaitingJobsNumber(int waitJobsNum) {
        A.ensure(waitJobsNum >= 0, "waitingJobsNum >= 0");
        this.waitJobsNum = waitJobsNum;
    }

    @Override
    public int getCurrentWaitJobsNumber() {
        return this.waitingCnt;
    }

    @Override
    public int getCurrentActiveJobsNumber() {
        return this.runningCnt + this.heldCnt;
    }

    @Override
    public int getCurrentRunningJobsNumber() {
        return this.runningCnt;
    }

    @Override
    public int getCurrentHeldJobsNumber() {
        return this.heldCnt;
    }

    @Override
    public void spiStart(String gridName) throws IgniteSpiException {
        this.assertParameter(this.parallelJobsNum > 0, "parallelJobsNum > 0");
        this.assertParameter(this.waitJobsNum >= 0, "waitingJobsNum >= 0");
        this.startStopwatch();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("parallelJobsNum", this.parallelJobsNum));
        }
        this.registerMBean(gridName, this, FifoQueueCollisionSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    public void setExternalCollisionListener(CollisionExternalListener lsnr) {
    }

    @Override
    public void onCollision(CollisionContext ctx) {
        int waitSize;
        assert (ctx != null);
        Collection<CollisionJobContext> activeJobs = ctx.activeJobs();
        Collection<CollisionJobContext> waitJobs = ctx.waitingJobs();
        int activeSize = activeJobs.size();
        this.waitingCnt = waitSize = waitJobs.size();
        this.runningCnt = activeSize;
        this.heldCnt = ctx.heldJobs().size();
        int parallelJobsNum0 = this.parallelJobsNum;
        Iterator<CollisionJobContext> it = null;
        if (activeSize < parallelJobsNum0) {
            it = waitJobs.iterator();
            while (it.hasNext()) {
                CollisionJobContext waitCtx = it.next();
                waitCtx.activate();
                if (--waitSize == 0) {
                    return;
                }
                if (activeJobs.size() < parallelJobsNum0) continue;
                break;
            }
        }
        int waitJobsNum0 = this.waitJobsNum;
        if (waitJobs.size() > waitJobsNum0) {
            if (it == null) {
                it = waitJobs.iterator();
            }
            while (it.hasNext()) {
                CollisionJobContext waitCtx = it.next();
                waitCtx.cancel();
                if (--waitSize == 0) {
                    return;
                }
                if (waitJobs.size() > waitJobsNum0) continue;
                return;
            }
        }
    }

    public String toString() {
        return S.toString(FifoQueueCollisionSpi.class, this);
    }
}

