/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.jetbrains.annotations.Nullable;

abstract class TcpDiscoveryImpl {
    protected static final int RES_OK = 1;
    protected static final int RES_CONTINUE_JOIN = 100;
    protected static final int RES_WAIT = 200;
    protected final TcpDiscoverySpi spi;
    protected final IgniteLogger log;
    protected TcpDiscoveryNode locNode;
    protected boolean debugMode;
    private int debugMsgHist = 512;
    protected ConcurrentLinkedDeque<String> debugLogQ;
    protected final DebugLogger debugLog = new DebugLogger(){

        @Override
        public boolean isDebugEnabled() {
            return TcpDiscoveryImpl.this.log.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            TcpDiscoveryImpl.this.log.debug(msg);
        }
    };
    protected final DebugLogger traceLog = new DebugLogger(){

        @Override
        public boolean isDebugEnabled() {
            return TcpDiscoveryImpl.this.log.isTraceEnabled();
        }

        @Override
        public void debug(String msg) {
            TcpDiscoveryImpl.this.log.trace(msg);
        }
    };

    TcpDiscoveryImpl(TcpDiscoverySpi spi) {
        this.spi = spi;
        this.log = spi.log;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDebugMessageHistory(int debugMsgHist) {
        this.debugMsgHist = debugMsgHist;
    }

    protected void debugLog(@Nullable TcpDiscoveryAbstractMessage discoMsg, String msg) {
        assert (this.debugMode);
        String msg0 = new SimpleDateFormat("[HH:mm:ss,SSS]").format(new Date(System.currentTimeMillis())) + '[' + Thread.currentThread().getName() + "][" + this.getLocalNodeId() + "-" + this.locNode.internalOrder() + "] " + msg;
        this.debugLogQ.add(msg0);
        int delta = this.debugLogQ.size() - this.debugMsgHist;
        for (int i = 0; i < delta && this.debugLogQ.size() > this.debugMsgHist; ++i) {
            this.debugLogQ.poll();
        }
    }

    public UUID getLocalNodeId() {
        return this.spi.locNode.id();
    }

    public UUID getConfiguredNodeId() {
        return this.spi.cfgNodeId;
    }

    protected void onException(String msg, Exception e) {
        this.spi.getExceptionRegistry().onException(msg, e);
    }

    protected void onMessageExchanged() {
    }

    public abstract void dumpDebugInfo(IgniteLogger var1);

    public abstract String getSpiState();

    public abstract int getMessageWorkerQueueSize();

    public abstract UUID getCoordinator();

    public abstract Collection<ClusterNode> getRemoteNodes();

    @Nullable
    public abstract ClusterNode getNode(UUID var1);

    public abstract boolean pingNode(UUID var1);

    public abstract void disconnect() throws IgniteSpiException;

    public abstract void sendCustomEvent(DiscoverySpiCustomMessage var1) throws IgniteException;

    public abstract void failNode(UUID var1, @Nullable String var2);

    public abstract void spiStart(@Nullable String var1) throws IgniteSpiException;

    public abstract void spiStop() throws IgniteSpiException;

    public abstract void onContextInitialized0(IgniteSpiContext var1) throws IgniteSpiException;

    protected static String threadStatus(Thread t) {
        if (t == null) {
            return "N/A";
        }
        return t.isAlive() ? "alive" : "dead";
    }

    abstract void simulateNodeFailure();

    public abstract void brakeConnection();

    protected abstract IgniteSpiThread workerThread();

    protected final void registerLocalNodeAddress() throws IgniteSpiException {
        long start = this.spi.getJoinTimeout() > 0L ? U.currentTimeMillis() : 0L;
        while (true) {
            try {
                this.spi.ipFinder.initializeLocalAddresses(U.resolveAddresses(this.spi.getAddressResolver(), this.locNode.socketAddresses()));
                break;
            }
            catch (IllegalStateException e) {
                throw new IgniteSpiException("Failed to register local node address with IP finder: " + this.locNode.socketAddresses(), e);
            }
            catch (IgniteSpiException e) {
                LT.error(this.log, e, "Failed to register local node address in IP finder on start (retrying every 2000 ms).");
                if (start > 0L && U.currentTimeMillis() - start > this.spi.getJoinTimeout()) {
                    throw new IgniteSpiException("Failed to register local addresses with IP finder within join timeout (make sure IP finder configuration is correct, and operating system firewalls are disabled on all host machines, or consider increasing 'joinTimeout' configuration property) [joinTimeout=" + this.spi.getJoinTimeout() + ']');
                }
                try {
                    U.sleep(2000L);
                }
                catch (IgniteInterruptedCheckedException e2) {
                    throw new IgniteSpiException("Thread has been interrupted.", e2);
                }
            }
        }
    }

    protected boolean checkAckTimeout(long ackTimeout) {
        if (ackTimeout > this.spi.getMaxAckTimeout()) {
            LT.warn(this.log, "Acknowledgement timeout is greater than maximum acknowledgement timeout (consider increasing 'maxAckTimeout' configuration property) [ackTimeout=" + ackTimeout + ", maxAckTimeout=" + this.spi.getMaxAckTimeout() + ']');
            return false;
        }
        return true;
    }

    protected static List<String> toOrderedList(Collection<InetSocketAddress> addrs) {
        ArrayList<String> res = new ArrayList<String>(addrs.size());
        for (InetSocketAddress addr : addrs) {
            res.add(addr.toString());
        }
        Collections.sort(res);
        return res;
    }

    protected final DebugLogger messageLogger(TcpDiscoveryAbstractMessage msg) {
        return msg.traceLogLevel() ? this.traceLog : this.debugLog;
    }

    static interface DebugLogger {
        public boolean isDebugEnabled();

        public void debug(String var1);
    }
}

