/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutHelper;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.IgniteSpiVersionCheckException;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiHistorySupport;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.spi.discovery.tcp.ClientImpl;
import org.apache.ignite.spi.discovery.tcp.ServerImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoveryImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpiMBean;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryStatistics;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAuthFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCheckFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDuplicateIdMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryEnsureDelivery;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@DiscoverySpiOrderSupport(value=true)
@DiscoverySpiHistorySupport(value=true)
public class TcpDiscoverySpi
extends IgniteSpiAdapter
implements DiscoverySpi,
TcpDiscoverySpiMBean {
    static final byte FAILURE_DETECTION_MAJOR_VER = 1;
    static final byte FAILURE_DETECTION_MINOR_VER = 4;
    static final byte FAILURE_DETECTION_MAINT_VER = 1;
    public static final String ATTR_EXT_ADDRS = "disc.tcp.ext-addrs";
    public static final int DFLT_PORT_RANGE = 100;
    public static final int DFLT_PORT = 47500;
    public static final long DFLT_JOIN_TIMEOUT = 0L;
    public static final long DFLT_NETWORK_TIMEOUT = 5000L;
    public static final int DFLT_THREAD_PRI = 10;
    public static final long DFLT_HEARTBEAT_FREQ = 2000L;
    public static final int DFLT_TOP_HISTORY_SIZE = 1000;
    public static final long DFLT_SOCK_TIMEOUT = 5000L;
    public static final long DFLT_ACK_TIMEOUT = 5000L;
    public static final long DFLT_SOCK_TIMEOUT_CLIENT = 5000L;
    public static final long DFLT_ACK_TIMEOUT_CLIENT = 5000L;
    public static final int DFLT_RECONNECT_CNT = 10;
    public static final int DFLT_MAX_MISSED_HEARTBEATS = 1;
    public static final int DFLT_MAX_MISSED_CLIENT_HEARTBEATS = 5;
    public static final long DFLT_IP_FINDER_CLEAN_FREQ = 60000L;
    public static final long DFLT_STATS_PRINT_FREQ = 0L;
    public static final long DFLT_MAX_ACK_TIMEOUT = 600000L;
    protected String locAddr;
    private AddressResolver addrRslvr;
    protected TcpDiscoveryIpFinder ipFinder;
    private long sockTimeout;
    private long ackTimeout;
    protected long netTimeout = 5000L;
    protected long joinTimeout = 0L;
    protected int threadPri = 10;
    protected long hbFreq = 2000L;
    protected int topHistSize = 1000;
    protected volatile DiscoverySpiListener lsnr;
    protected DiscoverySpiDataExchange exchange;
    protected DiscoveryMetricsProvider metricsProvider;
    protected Map<String, Object> locNodeAttrs;
    protected IgniteProductVersion locNodeVer;
    protected TcpDiscoveryNode locNode;
    protected UUID cfgNodeId;
    protected InetAddress locHost;
    protected Collection<InetSocketAddress> locNodeAddrs;
    protected volatile long gridStartTime;
    private final Marshaller marsh = new JdkMarshaller();
    protected final TcpDiscoveryStatistics stats = new TcpDiscoveryStatistics();
    protected int locPort = 47500;
    protected int locPortRange = 100;
    private int reconCnt = 10;
    protected long statsPrintFreq = 0L;
    private long maxAckTimeout = 600000L;
    protected int maxMissedHbs = 1;
    protected int maxMissedClientHbs = 5;
    protected long ipFinderCleanFreq = 60000L;
    protected DiscoverySpiNodeAuthenticator nodeAuth;
    protected SSLServerSocketFactory sslSrvSockFactory;
    protected SSLSocketFactory sslSockFactory;
    @GridToStringExclude
    private final CountDownLatch ctxInitLatch = new CountDownLatch(1);
    protected final CopyOnWriteArrayList<IgniteInClosure<TcpDiscoveryAbstractMessage>> sndMsgLsnrs = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<IgniteInClosure<Socket>> incomeConnLsnrs = new CopyOnWriteArrayList();
    @LoggerResource
    protected IgniteLogger log;
    protected TcpDiscoveryImpl impl;
    private boolean forceSrvMode;
    private boolean clientReconnectDisabled;

    @Override
    public String getSpiState() {
        return this.impl.getSpiState();
    }

    @Override
    public int getMessageWorkerQueueSize() {
        return this.impl.getMessageWorkerQueueSize();
    }

    @Override
    @Nullable
    public UUID getCoordinator() {
        return this.impl.getCoordinator();
    }

    @Override
    public Collection<ClusterNode> getRemoteNodes() {
        return this.impl.getRemoteNodes();
    }

    @Override
    @Nullable
    public ClusterNode getNode(UUID nodeId) {
        return this.impl.getNode(nodeId);
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        return this.impl.pingNode(nodeId);
    }

    @Override
    public void disconnect() throws IgniteSpiException {
        this.impl.disconnect();
    }

    @Override
    public void setAuthenticator(DiscoverySpiNodeAuthenticator auth) {
        this.nodeAuth = auth;
    }

    @Override
    public void sendCustomEvent(DiscoverySpiCustomMessage msg) throws IgniteException {
        this.impl.sendCustomEvent(msg);
    }

    @Override
    public void failNode(UUID nodeId, @Nullable String warning) {
        this.impl.failNode(nodeId, warning);
    }

    @Override
    public void dumpDebugInfo() {
        this.impl.dumpDebugInfo(this.log);
    }

    @Override
    public boolean isClientMode() {
        if (this.impl == null) {
            throw new IllegalStateException("TcpDiscoverySpi has not started.");
        }
        return this.impl instanceof ClientImpl;
    }

    public boolean isForceServerMode() {
        return this.forceSrvMode;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setForceServerMode(boolean forceSrvMode) {
        this.forceSrvMode = forceSrvMode;
        return this;
    }

    public boolean isClientReconnectDisabled() {
        return this.clientReconnectDisabled;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setClientReconnectDisabled(boolean clientReconnectDisabled) {
        this.clientReconnectDisabled = clientReconnectDisabled;
    }

    @Override
    @IgniteInstanceResource
    protected void injectResources(Ignite ignite) {
        super.injectResources(ignite);
        if (ignite != null) {
            this.setLocalAddress(ignite.configuration().getLocalHost());
            this.setAddressResolver(ignite.configuration().getAddressResolver());
        }
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setLocalAddress(String locAddr) {
        if (this.locAddr == null) {
            this.locAddr = locAddr;
        }
        return this;
    }

    public String getLocalAddress() {
        return this.locAddr;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setAddressResolver(AddressResolver addrRslvr) {
        if (this.addrRslvr == null) {
            this.addrRslvr = addrRslvr;
        }
    }

    public AddressResolver getAddressResolver() {
        return this.addrRslvr;
    }

    @Override
    public int getReconnectCount() {
        return this.reconCnt;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setReconnectCount(int reconCnt) {
        this.reconCnt = reconCnt;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    @Override
    public long getMaxAckTimeout() {
        return this.maxAckTimeout;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setMaxAckTimeout(long maxAckTimeout) {
        this.maxAckTimeout = maxAckTimeout;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    @Override
    public int getLocalPort() {
        TcpDiscoveryNode locNode0 = this.locNode;
        return locNode0 != null ? locNode0.discoveryPort() : 0;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setLocalPort(int locPort) {
        this.locPort = locPort;
        return this;
    }

    @Override
    public int getLocalPortRange() {
        return this.locPortRange;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setLocalPortRange(int locPortRange) {
        this.locPortRange = locPortRange;
        return this;
    }

    @Override
    public int getMaxMissedHeartbeats() {
        return this.maxMissedHbs;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setMaxMissedHeartbeats(int maxMissedHbs) {
        this.maxMissedHbs = maxMissedHbs;
        return this;
    }

    @Override
    public int getMaxMissedClientHeartbeats() {
        return this.maxMissedClientHbs;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setMaxMissedClientHeartbeats(int maxMissedClientHbs) {
        this.maxMissedClientHbs = maxMissedClientHbs;
        return this;
    }

    @Override
    public long getStatisticsPrintFrequency() {
        return this.statsPrintFreq;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setStatisticsPrintFrequency(long statsPrintFreq) {
        this.statsPrintFreq = statsPrintFreq;
        return this;
    }

    @Override
    public long getIpFinderCleanFrequency() {
        return this.ipFinderCleanFreq;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setIpFinderCleanFrequency(long ipFinderCleanFreq) {
        this.ipFinderCleanFreq = ipFinderCleanFreq;
        return this;
    }

    public TcpDiscoveryIpFinder getIpFinder() {
        return this.ipFinder;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setIpFinder(TcpDiscoveryIpFinder ipFinder) {
        this.ipFinder = ipFinder;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setSocketTimeout(long sockTimeout) {
        this.sockTimeout = sockTimeout;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setNetworkTimeout(long netTimeout) {
        this.netTimeout = netTimeout;
        return this;
    }

    @Override
    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setThreadPriority(int threadPri) {
        this.threadPri = threadPri;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setHeartbeatFrequency(long hbFreq) {
        this.hbFreq = hbFreq;
        return this;
    }

    public long getTopHistorySize() {
        return this.topHistSize;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setTopHistorySize(int topHistSize) {
        if (topHistSize < 1000) {
            U.warn(this.log, "Topology history size should be greater than or equal to default size. Specified size will not be set [curSize=" + this.topHistSize + ", specifiedSize=" + topHistSize + ", defaultSize=" + 1000 + ']');
            return this;
        }
        this.topHistSize = topHistSize;
        return this;
    }

    @Override
    public void setNodeAttributes(Map<String, Object> attrs, IgniteProductVersion ver) {
        assert (this.locNodeAttrs == null);
        assert (this.locNodeVer == null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node attributes to set: " + attrs);
            this.log.debug("Node version to set: " + ver);
        }
        this.locNodeAttrs = attrs;
        this.locNodeVer = ver;
    }

    protected void initLocalNode(int srvPort, boolean addExtAddrAttr) {
        IgniteBiTuple<Collection<String>, Collection<String>> addrs;
        try {
            addrs = U.resolveLocalAddresses(this.locHost);
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to resolve local host to set of external addresses: " + this.locHost, e);
        }
        this.locNode = new TcpDiscoveryNode(this.ignite.configuration().getNodeId(), addrs.get1(), addrs.get2(), srvPort, this.metricsProvider, this.locNodeVer, this.ignite.configuration().getConsistentId());
        if (addExtAddrAttr) {
            Collection<InetSocketAddress> extAddrs = this.addrRslvr == null ? null : U.resolveAddresses(this.addrRslvr, F.flat(Arrays.asList(addrs.get1(), addrs.get2())), this.locNode.discoveryPort());
            this.locNodeAddrs = new LinkedHashSet<InetSocketAddress>();
            this.locNodeAddrs.addAll(this.locNode.socketAddresses());
            if (extAddrs != null) {
                this.locNodeAttrs.put(this.createSpiAttributeName(ATTR_EXT_ADDRS), extAddrs);
                this.locNodeAddrs.addAll(extAddrs);
            }
        }
        this.locNode.setAttributes(this.locNodeAttrs);
        this.locNode.local(true);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Local node initialized: " + this.locNode);
        }
    }

    LinkedHashSet<InetSocketAddress> getNodeAddresses(TcpDiscoveryNode node) {
        LinkedHashSet<InetSocketAddress> res = new LinkedHashSet<InetSocketAddress>(node.socketAddresses());
        Collection extAddrs = (Collection)node.attribute(this.createSpiAttributeName(ATTR_EXT_ADDRS));
        if (extAddrs != null) {
            res.addAll(extAddrs);
        }
        return res;
    }

    LinkedHashSet<InetSocketAddress> getNodeAddresses(TcpDiscoveryNode node, boolean sameHost) {
        List addrs = U.arrayList(node.socketAddresses());
        Collections.sort(addrs, U.inetAddressesComparator(sameHost));
        LinkedHashSet<InetSocketAddress> res = new LinkedHashSet<InetSocketAddress>();
        InetSocketAddress lastAddr = node.lastSuccessfulAddress();
        if (lastAddr != null) {
            res.add(lastAddr);
        }
        res.addAll(addrs);
        Collection extAddrs = (Collection)node.attribute(this.createSpiAttributeName(ATTR_EXT_ADDRS));
        if (extAddrs != null) {
            res.addAll(extAddrs);
        }
        return res;
    }

    @Override
    public Collection<Object> injectables() {
        return F.asList(this.ipFinder);
    }

    @Override
    public long getSocketTimeout() {
        return this.sockTimeout;
    }

    @Override
    public long getAckTimeout() {
        return this.ackTimeout;
    }

    @Override
    public long getNetworkTimeout() {
        return this.netTimeout;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPri;
    }

    @Override
    public long getHeartbeatFrequency() {
        return this.hbFreq;
    }

    @Override
    public String getIpFinderFormatted() {
        return this.ipFinder.toString();
    }

    @Override
    public long getNodesJoined() {
        return this.stats.joinedNodesCount();
    }

    @Override
    public long getNodesLeft() {
        return this.stats.leftNodesCount();
    }

    @Override
    public long getNodesFailed() {
        return this.stats.failedNodesCount();
    }

    @Override
    public long getPendingMessagesRegistered() {
        return this.stats.pendingMessagesRegistered();
    }

    @Override
    public long getPendingMessagesDiscarded() {
        return this.stats.pendingMessagesDiscarded();
    }

    @Override
    public long getAvgMessageProcessingTime() {
        return this.stats.avgMessageProcessingTime();
    }

    @Override
    public long getMaxMessageProcessingTime() {
        return this.stats.maxMessageProcessingTime();
    }

    @Override
    public int getTotalReceivedMessages() {
        return this.stats.totalReceivedMessages();
    }

    @Override
    public Map<String, Integer> getReceivedMessages() {
        return this.stats.receivedMessages();
    }

    @Override
    public int getTotalProcessedMessages() {
        return this.stats.totalProcessedMessages();
    }

    @Override
    public Map<String, Integer> getProcessedMessages() {
        return this.stats.processedMessages();
    }

    @Override
    public long getCoordinatorSinceTimestamp() {
        return this.stats.coordinatorSinceTimestamp();
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        super.onContextInitialized0(spiCtx);
        this.ctxInitLatch.countDown();
        this.ipFinder.onSpiContextInitialized(spiCtx);
        this.impl.onContextInitialized0(spiCtx);
    }

    @Override
    protected void onContextDestroyed0() {
        super.onContextDestroyed0();
        if (this.ctxInitLatch.getCount() > 0L) {
            this.ctxInitLatch.countDown();
        }
        if (this.ipFinder != null) {
            this.ipFinder.onSpiContextDestroyed();
        }
        this.getSpiContext().deregisterPorts();
    }

    @Override
    public IgniteSpiContext getSpiContext() {
        if (this.ctxInitLatch.getCount() > 0L) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Waiting for context initialization.");
            }
            try {
                U.await(this.ctxInitLatch);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Context has been initialized.");
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Thread has been interrupted while waiting for SPI context initialization.", e);
            }
        }
        return super.getSpiContext();
    }

    @Override
    public ClusterNode getLocalNode() {
        return this.locNode;
    }

    @Override
    public void setListener(@Nullable DiscoverySpiListener lsnr) {
        this.lsnr = lsnr;
    }

    @Override
    public TcpDiscoverySpi setDataExchange(DiscoverySpiDataExchange exchange) {
        this.exchange = exchange;
        return this;
    }

    @Override
    public TcpDiscoverySpi setMetricsProvider(DiscoveryMetricsProvider metricsProvider) {
        this.metricsProvider = metricsProvider;
        return this;
    }

    @Override
    public long getGridStartTime() {
        assert (this.gridStartTime != 0L);
        return this.gridStartTime;
    }

    protected Socket openSocket(InetSocketAddress sockAddr, IgniteSpiOperationTimeoutHelper timeoutHelper) throws IOException, IgniteSpiOperationTimeoutException {
        return this.openSocket(this.createSocket(), sockAddr, timeoutHelper);
    }

    final BufferedOutputStream socketStream(Socket sock) throws IOException {
        int bufSize = sock.getSendBufferSize();
        return bufSize > 0 ? new BufferedOutputStream(sock.getOutputStream(), bufSize) : new BufferedOutputStream(sock.getOutputStream());
    }

    protected Socket openSocket(Socket sock, InetSocketAddress remAddr, IgniteSpiOperationTimeoutHelper timeoutHelper) throws IOException, IgniteSpiOperationTimeoutException {
        assert (remAddr != null);
        InetSocketAddress resolved = remAddr.isUnresolved() ? new InetSocketAddress(InetAddress.getByName(remAddr.getHostName()), remAddr.getPort()) : remAddr;
        InetAddress addr = resolved.getAddress();
        assert (addr != null);
        sock.connect(resolved, (int)timeoutHelper.nextTimeoutChunk(this.sockTimeout));
        this.writeToSocket(sock, null, U.IGNITE_HEADER, timeoutHelper.nextTimeoutChunk(this.sockTimeout));
        return sock;
    }

    Socket createSocket() throws IOException {
        Socket sock = this.isSslEnabled() ? this.sslSockFactory.createSocket() : new Socket();
        sock.bind(new InetSocketAddress(this.locHost, 0));
        sock.setTcpNoDelay(true);
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(Socket sock, TcpDiscoveryAbstractMessage msg, byte[] data, long timeout) throws IOException {
        block9: {
            assert (sock != null);
            assert (data != null);
            SocketTimeoutObject obj = new SocketTimeoutObject(sock, U.currentTimeMillis() + timeout);
            this.addTimeoutObject(obj);
            IOException err = null;
            try {
                OutputStream out = sock.getOutputStream();
                out.write(data);
                out.flush();
            }
            catch (IOException e) {
                err = e;
            }
            finally {
                boolean cancelled = obj.cancel();
                if (cancelled) {
                    this.removeTimeoutObject(obj);
                }
                if (err != null) {
                    throw err;
                }
                if (cancelled) break block9;
                throw new SocketTimeoutException("Write timed out (socket was concurrently closed).");
            }
        }
    }

    protected void writeToSocket(Socket sock, TcpDiscoveryAbstractMessage msg, long timeout) throws IOException, IgniteCheckedException {
        this.writeToSocket(sock, this.socketStream(sock), msg, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(Socket sock, OutputStream out, TcpDiscoveryAbstractMessage msg, long timeout) throws IOException, IgniteCheckedException {
        block10: {
            assert (sock != null);
            assert (msg != null);
            assert (out != null);
            SocketTimeoutObject obj = new SocketTimeoutObject(sock, U.currentTimeMillis() + timeout);
            this.addTimeoutObject(obj);
            IgniteCheckedException err = null;
            try {
                U.marshal(this.marshaller(), msg, out);
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            finally {
                boolean cancelled = obj.cancel();
                if (cancelled) {
                    this.removeTimeoutObject(obj);
                }
                if (err != null) {
                    throw err;
                }
                if (cancelled) break block10;
                throw new SocketTimeoutException("Write timed out (socket was concurrently closed).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(TcpDiscoveryAbstractMessage msg, Socket sock, int res, long timeout) throws IOException {
        block8: {
            assert (sock != null);
            SocketTimeoutObject obj = new SocketTimeoutObject(sock, U.currentTimeMillis() + timeout);
            this.addTimeoutObject(obj);
            OutputStream out = sock.getOutputStream();
            IOException err = null;
            try {
                out.write(res);
                out.flush();
            }
            catch (IOException e) {
                err = e;
            }
            finally {
                boolean cancelled = obj.cancel();
                if (cancelled) {
                    this.removeTimeoutObject(obj);
                }
                if (err != null) {
                    throw err;
                }
                if (cancelled) break block8;
                throw new SocketTimeoutException("Write timed out (socket was concurrently closed).");
            }
        }
    }

    protected <T> T readMessage(Socket sock, @Nullable InputStream in, long timeout) throws IOException, IgniteCheckedException {
        Object t;
        assert (sock != null);
        int oldTimeout = sock.getSoTimeout();
        try {
            Object res;
            sock.setSoTimeout((int)timeout);
            t = res = U.unmarshal(this.marshaller(), in == null ? sock.getInputStream() : in, U.resolveClassLoader(this.ignite.configuration()));
        }
        catch (IOException | IgniteCheckedException e) {
            if (X.hasCause(e, SocketTimeoutException.class)) {
                LT.warn(this.log, "Timed out waiting for message to be read (most probably, the reason is in long GC pauses on remote node) [curTimeout=" + timeout + ']');
            }
            throw e;
        }
        finally {
            try {
                sock.setSoTimeout(oldTimeout);
            }
            catch (SocketException socketException) {}
        }
        return t;
    }

    protected int readReceipt(Socket sock, long timeout) throws IOException {
        assert (sock != null);
        int oldTimeout = sock.getSoTimeout();
        try {
            sock.setSoTimeout((int)timeout);
            int res = sock.getInputStream().read();
            if (res == -1) {
                throw new EOFException();
            }
            int n = res;
            return n;
        }
        catch (SocketTimeoutException e) {
            LT.warn(this.log, "Timed out waiting for message delivery receipt (most probably, the reason is in long GC pauses on remote node; consider tuning GC and increasing 'ackTimeout' configuration property). Will retry to send message with increased timeout. Current timeout: " + timeout + '.');
            this.stats.onAckTimeout();
            throw e;
        }
        finally {
            try {
                sock.setSoTimeout(oldTimeout);
            }
            catch (SocketException socketException) {}
        }
    }

    protected Collection<InetSocketAddress> resolvedAddresses() throws IgniteSpiException {
        Collection<InetSocketAddress> addrs;
        ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>();
        while (true) {
            try {
                addrs = this.registeredAddresses();
                break;
            }
            catch (IgniteSpiException e) {
                LT.error(this.log, e, "Failed to get registered addresses from IP finder on start (retrying every 2000 ms).");
                try {
                    U.sleep(2000L);
                }
                catch (IgniteInterruptedCheckedException e2) {
                    throw new IgniteSpiException("Thread has been interrupted.", e2);
                }
            }
        }
        for (InetSocketAddress addr : addrs) {
            assert (addr != null);
            try {
                InetSocketAddress resolved;
                InetSocketAddress inetSocketAddress = resolved = addr.isUnresolved() ? new InetSocketAddress(InetAddress.getByName(addr.getHostName()), addr.getPort()) : addr;
                if (this.locNodeAddrs != null && this.locNodeAddrs.contains(resolved)) continue;
                res.add(resolved);
            }
            catch (UnknownHostException ignored) {
                LT.warn(this.log, "Failed to resolve address from IP finder (host is unknown): " + addr);
                res.add(addr);
            }
        }
        if (!res.isEmpty()) {
            Collections.shuffle(res);
        }
        return res;
    }

    protected Collection<InetSocketAddress> registeredAddresses() throws IgniteSpiException {
        ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress addr : this.ipFinder.getRegisteredAddresses()) {
            if (addr.getPort() == 0) {
                int port = this.locNode.discoveryPort() != 0 ? this.locNode.discoveryPort() : 47500;
                addr = addr.isUnresolved() ? new InetSocketAddress(addr.getHostName(), port) : new InetSocketAddress(addr.getAddress(), port);
            }
            res.add(addr);
        }
        return res;
    }

    protected IgniteSpiException duplicateIdError(TcpDiscoveryDuplicateIdMessage msg) {
        assert (msg != null);
        return new IgniteSpiException("Local node has the same ID as existing node in topology (fix configuration and restart local node) [localNode=" + this.locNode + ", existingNode=" + msg.node() + ']');
    }

    protected IgniteSpiException authenticationFailedError(TcpDiscoveryAuthFailedMessage msg) {
        assert (msg != null);
        return new IgniteSpiException(new IgniteAuthenticationException("Authentication failed [nodeId=" + msg.creatorNodeId() + ", addr=" + msg.address().getHostAddress() + ']'));
    }

    protected IgniteSpiException checkFailedError(TcpDiscoveryCheckFailedMessage msg) {
        assert (msg != null);
        return TcpDiscoverySpi.versionCheckFailed(msg) ? new IgniteSpiVersionCheckException(msg.error()) : new IgniteSpiException(msg.error());
    }

    protected boolean ensured(TcpDiscoveryAbstractMessage msg) {
        return U.getAnnotation(msg.getClass(), TcpDiscoveryEnsureDelivery.class) != null;
    }

    @Deprecated
    private static boolean versionCheckFailed(TcpDiscoveryCheckFailedMessage msg) {
        return msg.error().contains("versions are not compatible");
    }

    protected Map<Integer, byte[]> collectExchangeData(UUID nodeId) {
        if (this.locNode.isDaemon()) {
            return Collections.emptyMap();
        }
        Map<Integer, Serializable> data = this.exchange.collect(nodeId);
        assert (data != null);
        HashMap<Integer, byte[]> data0 = U.newHashMap(data.size());
        for (Map.Entry<Integer, Serializable> entry : data.entrySet()) {
            try {
                byte[] bytes = U.marshal(this.marshaller(), (Object)entry.getValue());
                data0.put(entry.getKey(), bytes);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to marshal discovery data [comp=" + entry.getKey() + ", data=" + entry.getValue() + ']', e);
            }
        }
        return data0;
    }

    protected void onExchange(UUID joiningNodeID, UUID nodeId, Map<Integer, byte[]> data, ClassLoader clsLdr) {
        if (this.locNode.isDaemon()) {
            return;
        }
        HashMap<Integer, Serializable> data0 = U.newHashMap(data.size());
        for (Map.Entry<Integer, byte[]> entry : data.entrySet()) {
            try {
                Serializable compData = (Serializable)U.unmarshal(this.marshaller(), entry.getValue(), clsLdr);
                data0.put(entry.getKey(), compData);
            }
            catch (IgniteCheckedException e) {
                if (GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal() == entry.getKey().intValue() && X.hasCause(e, ClassNotFoundException.class) && this.locNode.isClient()) {
                    U.warn(this.log, "Failed to unmarshal continuous query remote filter on client node. Can be ignored.");
                    continue;
                }
                U.error(this.log, "Failed to unmarshal discovery data for component: " + entry.getKey(), e);
            }
        }
        this.exchange.onExchange(joiningNodeID, nodeId, data0);
    }

    @Override
    public void spiStart(@Nullable String gridName) throws IgniteSpiException {
        TcpDiscoveryMulticastIpFinder mcastIpFinder;
        this.initFailureDetectionTimeout();
        if (!this.forceSrvMode && Boolean.TRUE.equals(this.ignite.configuration().isClientMode())) {
            if (this.ackTimeout == 0L) {
                this.ackTimeout = 5000L;
            }
            if (this.sockTimeout == 0L) {
                this.sockTimeout = 5000L;
            }
            this.impl = new ClientImpl(this);
            this.ctxInitLatch.countDown();
        } else {
            if (this.ackTimeout == 0L) {
                this.ackTimeout = 5000L;
            }
            if (this.sockTimeout == 0L) {
                this.sockTimeout = 5000L;
            }
            this.impl = new ServerImpl(this);
        }
        if (!this.failureDetectionTimeoutEnabled()) {
            this.assertParameter(this.sockTimeout > 0L, "sockTimeout > 0");
            this.assertParameter(this.ackTimeout > 0L, "ackTimeout > 0");
            this.assertParameter(this.maxAckTimeout > this.ackTimeout, "maxAckTimeout > ackTimeout");
            this.assertParameter(this.reconCnt > 0, "reconnectCnt > 0");
        }
        this.assertParameter(this.netTimeout > 0L, "networkTimeout > 0");
        this.assertParameter(this.ipFinder != null, "ipFinder != null");
        this.assertParameter(this.hbFreq > 0L, "heartbeatFreq > 0");
        this.assertParameter(this.ipFinderCleanFreq > 0L, "ipFinderCleanFreq > 0");
        this.assertParameter(this.locPort > 1023, "localPort > 1023");
        this.assertParameter(this.locPortRange >= 0, "localPortRange >= 0");
        this.assertParameter(this.locPort + this.locPortRange <= 65535, "locPort + locPortRange <= 0xffff");
        this.assertParameter(this.maxMissedHbs > 0, "maxMissedHeartbeats > 0");
        this.assertParameter(this.maxMissedClientHbs > 0, "maxMissedClientHeartbeats > 0");
        this.assertParameter(this.threadPri > 0, "threadPri > 0");
        this.assertParameter(this.statsPrintFreq >= 0L, "statsPrintFreq >= 0");
        if (this.isSslEnabled()) {
            try {
                SSLContext sslCtx = this.ignite().configuration().getSslContextFactory().create();
                this.sslSockFactory = sslCtx.getSocketFactory();
                this.sslSrvSockFactory = sslCtx.getServerSocketFactory();
            }
            catch (IgniteException e) {
                throw new IgniteSpiException("Failed to create SSL context. SSL factory: " + this.ignite.configuration().getSslContextFactory(), e);
            }
        }
        try {
            this.locHost = U.resolveLocalHost(this.locAddr);
        }
        catch (IOException e) {
            throw new IgniteSpiException("Unknown local address: " + this.locAddr, e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("localHost", this.locHost.getHostAddress()));
            this.log.debug(this.configInfo("localPort", this.locPort));
            this.log.debug(this.configInfo("localPortRange", this.locPortRange));
            this.log.debug(this.configInfo("threadPri", this.threadPri));
            if (!this.failureDetectionTimeoutEnabled()) {
                this.log.debug("Failure detection timeout is ignored because at least one of the parameters from this list has been set explicitly: 'sockTimeout', 'ackTimeout', 'maxAckTimeout', 'reconnectCount'.");
                this.log.debug(this.configInfo("networkTimeout", this.netTimeout));
                this.log.debug(this.configInfo("sockTimeout", this.sockTimeout));
                this.log.debug(this.configInfo("ackTimeout", this.ackTimeout));
                this.log.debug(this.configInfo("maxAckTimeout", this.maxAckTimeout));
                this.log.debug(this.configInfo("reconnectCount", this.reconCnt));
            } else {
                this.log.debug(this.configInfo("failureDetectionTimeout", this.failureDetectionTimeout()));
            }
            this.log.debug(this.configInfo("ipFinder", this.ipFinder));
            this.log.debug(this.configInfo("ipFinderCleanFreq", this.ipFinderCleanFreq));
            this.log.debug(this.configInfo("heartbeatFreq", this.hbFreq));
            this.log.debug(this.configInfo("maxMissedHeartbeats", this.maxMissedHbs));
            this.log.debug(this.configInfo("statsPrintFreq", this.statsPrintFreq));
        }
        if (this.netTimeout < 3000L) {
            U.warn(this.log, "Network timeout is too low (at least 3000 ms recommended): " + this.netTimeout);
        }
        this.registerMBean(gridName, this, TcpDiscoverySpiMBean.class);
        if (this.ipFinder instanceof TcpDiscoveryMulticastIpFinder && (mcastIpFinder = (TcpDiscoveryMulticastIpFinder)this.ipFinder).getLocalAddress() == null) {
            mcastIpFinder.setLocalAddress(this.locAddr);
        }
        this.cfgNodeId = this.ignite.configuration().getNodeId();
        this.impl.spiStart(gridName);
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        if (this.ctxInitLatch.getCount() > 0L) {
            this.ctxInitLatch.countDown();
        }
        if (this.ipFinder != null) {
            try {
                this.ipFinder.close();
            }
            catch (Exception e) {
                this.log.error("Failed to close ipFinder", e);
            }
        }
        this.unregisterMBean();
        if (this.impl != null) {
            this.impl.spiStop();
        }
    }

    void printStartInfo() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    void printStopInfo() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    Ignite ignite() {
        return this.ignite;
    }

    boolean isNodeStopping0() {
        return this.isNodeStopping();
    }

    boolean ipFinderHasLocalAddress() throws IgniteSpiException {
        for (InetSocketAddress locAddr : this.locNodeAddrs) {
            for (InetSocketAddress addr : this.registeredAddresses()) {
                try {
                    int port = addr.getPort();
                    InetSocketAddress resolved = addr.isUnresolved() ? new InetSocketAddress(InetAddress.getByName(addr.getHostName()), port) : new InetSocketAddress(addr.getAddress(), port);
                    if (!resolved.equals(locAddr)) continue;
                    return true;
                }
                catch (UnknownHostException e) {
                    this.getExceptionRegistry().onException(e.getMessage(), e);
                }
            }
        }
        return false;
    }

    boolean isSslEnabled() {
        return this.ignite().configuration().getSslContextFactory() != null;
    }

    public int clientWorkerCount() {
        return ((ServerImpl)this.impl).clientMsgWorkers.size();
    }

    void forceNextNodeFailure() {
        ((ServerImpl)this.impl).forceNextNodeFailure();
    }

    public void addSendMessageListener(IgniteInClosure<TcpDiscoveryAbstractMessage> lsnr) {
        this.sndMsgLsnrs.add(lsnr);
    }

    public void removeSendMessageListener(IgniteInClosure<TcpDiscoveryAbstractMessage> lsnr) {
        this.sndMsgLsnrs.remove(lsnr);
    }

    public void addIncomeConnectionListener(IgniteInClosure<Socket> lsnr) {
        this.incomeConnLsnrs.add(lsnr);
    }

    public void removeIncomeConnectionListener(IgniteInClosure<Socket> lsnr) {
        this.incomeConnLsnrs.remove(lsnr);
    }

    public void waitForClientMessagePrecessed() {
        if (this.impl instanceof ClientImpl) {
            ((ClientImpl)this.impl).waitForClientMessagePrecessed();
        }
    }

    protected void simulateNodeFailure() {
        this.impl.simulateNodeFailure();
    }

    public void brakeConnection() {
        this.impl.brakeConnection();
    }

    protected Marshaller marshaller() {
        MarshallerUtils.setNodeName(this.marsh, this.gridName);
        return this.marsh;
    }

    public String toString() {
        return S.toString(TcpDiscoverySpi.class, this);
    }

    private class SocketTimeoutObject
    implements IgniteSpiTimeoutObject {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final Socket sock;
        private final long endTime;
        private final AtomicBoolean done = new AtomicBoolean();

        SocketTimeoutObject(Socket sock, long endTime) {
            assert (sock != null);
            assert (endTime > 0L);
            this.sock = sock;
            this.endTime = endTime;
        }

        boolean cancel() {
            return this.done.compareAndSet(false, true);
        }

        @Override
        public void onTimeout() {
            if (this.done.compareAndSet(false, true)) {
                U.closeQuiet(this.sock);
                LT.warn(TcpDiscoverySpi.this.log, "Socket write has timed out (consider increasing " + (TcpDiscoverySpi.this.failureDetectionTimeoutEnabled() ? "'IgniteConfiguration.failureDetectionTimeout' configuration property) [failureDetectionTimeout=" + TcpDiscoverySpi.this.failureDetectionTimeout() + ']' : "'sockTimeout' configuration property) [sockTimeout=" + TcpDiscoverySpi.this.sockTimeout + ']'));
                TcpDiscoverySpi.this.stats.onSocketTimeout();
            }
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public IgniteUuid id() {
            return this.id;
        }

        public String toString() {
            return S.toString(SocketTimeoutObject.class, this);
        }
    }
}

